/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.recipe.impl;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.impl.StackOutput;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class RandomOutput
extends StackOutput {
    private static final Random RANDOM = new Random();
    private int min;
    private int max;

    public RandomOutput(ItemStack stack, int min, int max) {
        super(stack);
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private int rand() {
        return RANDOM.nextInt(this.max - this.min + 1) + this.min;
    }

    public ItemStack getRandomStack() {
        return InvUtils.setCount(this.getOutput(), this.rand());
    }

    @Override
    public RandomOutput copy() {
        return new RandomOutput(this.getOutput(), this.min, this.max);
    }

    @Override
    public String getTooltip() {
        return I18n.format((String)"bwm.random_output.tooltip", (Object[])new Object[]{this.min, this.max});
    }

    @Override
    public boolean equals(IOutput output) {
        if (output instanceof RandomOutput) {
            RandomOutput other = (RandomOutput)output;
            return this.getMax() == other.getMax() && this.getMin() == other.getMin() && InvUtils.matches(other.getOutput(), this.getOutput());
        }
        return false;
    }
}

