/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.recipe.impl;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.ChanceOutput;
import betterwithmods.api.recipe.impl.StackOutput;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ChanceOutputs
implements IRecipeOutputs {
    private static final Random RANDOM = new Random();
    protected List<ChanceOutput> weightedItemStacks;
    private List<ItemStack> itemStacksList;

    public ChanceOutputs(ItemStack stack, double weight) {
        this(new ChanceOutput(stack, weight));
    }

    public ChanceOutputs(ChanceOutput ... weightedItemStacks) {
        this(Lists.newArrayList((Object[])weightedItemStacks));
    }

    public ChanceOutputs(List<ChanceOutput> weightedItemStacks) {
        this.weightedItemStacks = weightedItemStacks;
        this.itemStacksList = weightedItemStacks.stream().map(StackOutput::getOutput).collect(Collectors.toList());
    }

    @Override
    public List<IOutput> getDisplayOutputs() {
        return this.cast(this.weightedItemStacks);
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        NonNullList outputs = NonNullList.create();
        for (ChanceOutput output : this.weightedItemStacks) {
            if (!(RANDOM.nextDouble() < output.getWeight())) continue;
            outputs.add((Object)output.getOutput());
        }
        return outputs;
    }

    @Override
    public boolean matches(List<ItemStack> outputs) {
        return InvUtils.matchesExact(outputs, this.itemStacksList);
    }

    @Override
    public boolean matchesFuzzy(List<ItemStack> outputs) {
        return InvUtils.matches(outputs, this.itemStacksList);
    }

    @Override
    public boolean isInvalid() {
        return this.weightedItemStacks.isEmpty();
    }
}

