package betterwithmods.util.fluid;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

import javax.annotation.Nullable;

public class BlockLiquidWrapper implements IFluidHandler {
    protected final BlockLiquid blockLiquid;
    protected final World world;
    protected final BlockPos blockPos;

    public BlockLiquidWrapper(BlockLiquid blockLiquid, World world, BlockPos blockPos) {
        this.blockLiquid = blockLiquid;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        FluidStack containedStack = null;
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_177230_c() == blockLiquid) {
            containedStack = getStack(blockState);
        }
        return new FluidTankProperties[]{new FluidTankProperties(containedStack, Fluid.BUCKET_VOLUME, false, true)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {

        // NOTE: "Filling" means placement in this context!
        if (resource.amount < Fluid.BUCKET_VOLUME) {
            return 0;
        }

        if (doFill) {
            Material material = blockLiquid.func_176223_P().func_185904_a();
            BlockLiquid block = BlockLiquid.func_176361_a(material);
            if (!world.field_72995_K) {
                setLiquid(world, blockPos, block, 2);
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos p2 = blockPos.func_177972_a(facing);
                    setLiquid(world, p2, block, 5);
                }
            }
        }
        return Fluid.BUCKET_VOLUME;
    }

    public void setLiquid(World world, BlockPos pos, Block block, int level) {
        IBlockState state = world.func_180495_p(pos);
        Block existingBlock = state.func_177230_c();
        if ((existingBlock instanceof BlockLiquid && state.func_177229_b(BlockLiquid.field_176367_b) > level) || (!state.func_185904_a().func_76224_d() && existingBlock.func_176200_f(world, pos))) {
            world.func_180501_a(pos, block.func_176223_P().func_177226_a(BlockLiquid.field_176367_b, level), 11);
        }
    }

    @Nullable
    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount < Fluid.BUCKET_VOLUME) {
            return null;
        }

        IBlockState blockState = world.func_180495_p(blockPos);
        //Ignore the level of the fluid, so we can fill from flowing liquids in HCBuckets.
        if (blockState.func_177230_c() == blockLiquid /*&& blockState.getValue(BlockLiquid.LEVEL) == 0*/) {
            FluidStack containedStack = getStack(blockState);
            if (containedStack != null && resource.containsFluid(containedStack)) {
                //Don't remove the block ever for HCBuckets
//                if (doDrain) {
//                    world.setBlockState(blockPos, Blocks.AIR.getDefaultState(), 11);
//                }
                return containedStack;
            }

        }
        return null;
    }

    @Nullable
    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        //HCBuckets doesn't remove the block, so it doesn't matter how much the container holds
//        if (maxDrain < Fluid.BUCKET_VOLUME) {
//            return null;
//        }

        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_177230_c() == blockLiquid) {
            FluidStack containedStack = getStack(blockState);


            if (containedStack != null) {
                if (containedStack.getFluid() == FluidRegistry.LAVA && containedStack.amount <= maxDrain) {
                    if (doDrain) {
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
                    }
                    return null;
                }

                //Don't remove the block ever for HCBuckets
//
                containedStack.amount = maxDrain;
                return containedStack;
            }

        }
        return null;
    }

    @Nullable
    private FluidStack getStack(IBlockState blockState) {
        Material material = blockState.func_185904_a();
        //Ignore level for HCBuckets only for water
        if (material == Material.field_151586_h /*&& blockState.getValue(BlockLiquid.LEVEL) == 0*/) {
            return new FluidStack(FluidRegistry.WATER, Fluid.BUCKET_VOLUME);
        } else if (material == Material.field_151587_i && blockState.func_177229_b(BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, Fluid.BUCKET_VOLUME);
        } else {
            return null;
        }
    }
}
