package betterwithmods.util;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

import javax.annotation.Nonnull;

public class StackEjector {

    private final World world;
    private final ItemStack stack;
    private Vec3d position, motion;
    private int pickupDelay;

    public StackEjector(@Nonnull World world, @Nonnull ItemStack stack, Vec3d position, Vec3d motion) {
        this.world = world;
        this.stack = stack;
        this.position = position;
        this.motion = motion;
    }

    public StackEjector(@Nonnull World world, @Nonnull ItemStack stack, Vec3d position) {
        this.world = world;
        this.stack = stack;
        this.position = position;
    }

    public void ejectStack() {
        if (world.field_72995_K)
            return;
        if(stack == null)
            return;
        if (position == null)
            return;
        EntityItem item = new EntityItem(world, position.field_72450_a, position.field_72448_b, position.field_72449_c, stack);
        item.func_174867_a(pickupDelay);
        if (motion != null) {
            item.field_70159_w = motion.field_72450_a;
            item.field_70181_x = motion.field_72448_b;
            item.field_70179_y = motion.field_72449_c;
        }
        world.func_72838_d(item);
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }


}
