package betterwithmods.util;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

/*
Borrowed from https://github.com/AlgorithmX2/Chisels-and-Bits
Copyright (C) 2017 AlgorithmX2 LGPLv3.0
 */
public class ReflectionHelperBlock extends Block {
    public String MethodName;

    private void markMethod() {
        MethodName = new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName();
    }


    public ReflectionHelperBlock() {
        super(Material.field_151579_a);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        markMethod();
        return false;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        markMethod();
    }

    @Override
    public float func_176195_g(
            final @Nullable IBlockState state,
            final @Nullable World world,
            final @Nullable BlockPos pos) {
        markMethod();
        return 0;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox,
                                      List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        markMethod();
    }

    @Override
    public float func_180647_a(
            final @Nullable IBlockState state,
            final @Nullable EntityPlayer player,
            final @Nullable World world,
            final @Nullable BlockPos pos) {
        markMethod();
        return 0;
    }

    @Override
    public float func_149638_a(
            final @Nullable Entity exploder) {
        markMethod();
        return 0;
    }

    @Override
    public float getExplosionResistance(
            final @Nullable World world,
            final @Nullable BlockPos pos,
            final @Nullable Entity exploder,
            final @Nullable Explosion explosion) {
        markMethod();
        return 0;
    }

    @Override
    public int quantityDropped(
            final @Nullable IBlockState state,
            final int fortune,
            final @Nullable Random random) {

        markMethod();
        return 0;
    }

    @Override
    public int func_149745_a(
            final @Nullable Random random) {
        markMethod();
        return 0;
    }

    @Override
    public int func_149679_a(
            final int fortune,
            final @Nullable Random random) {
        markMethod();
        return 0;
    }

    @Override
    public void func_180634_a(
            final @Nullable World worldIn,
            final @Nullable BlockPos pos,
            final @Nullable IBlockState state,
            final @Nullable Entity entityIn) {
        markMethod();
    }
}
