package betterwithmods.util;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

import java.util.Optional;

public class EntityUtils {

    public static void removeAI(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        entity.field_70714_bg.field_75782_a.removeIf(entityAITaskEntry -> clazz.isAssignableFrom(entityAITaskEntry.field_75733_a.getClass()));
    }

    public static boolean hasAI(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        return entity.field_70714_bg.field_75782_a.stream().anyMatch(entityAITaskEntry -> clazz.isAssignableFrom(entityAITaskEntry.field_75733_a.getClass()));
    }

    public  static <T extends EntityAIBase> Optional<T> findFirst(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        return entity.field_70714_bg.field_75782_a.stream().filter( t -> clazz.isAssignableFrom(t.getClass())).map( t -> (T)t.field_75733_a).findFirst();
    }

    public static void copyEntityInfo(EntityLivingBase copyFrom, EntityLivingBase copyTo) {
        copyTo.func_70606_j(copyFrom.func_110143_aJ());
        copyTo.func_70080_a(copyFrom.field_70165_t, copyFrom.field_70163_u, copyFrom.field_70161_v, copyFrom.field_70177_z, copyFrom.field_70125_A);
        copyTo.func_70034_d(copyFrom.func_70079_am());
    }

}
