package betterwithmods.util;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.*;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenserBehaviorFiniteWater extends BehaviorDefaultDispenseItem {
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    /**
     * Dispense the specified stack, play the dispense sound and spawn particles.
     */
    @Override
    public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        if (FluidUtil.getFluidContained(stack) != null) {
            return dumpContainer(source, stack);
        } else {
            return fillContainer(source, stack);
        }
    }

    /**
     * Picks up fluid in front of a Dispenser and fills a container with it.
     */
    private ItemStack fillContainer(IBlockSource source, ItemStack stack) {
        World world = source.func_82618_k();
        EnumFacing dispenserFacing = source.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);

        ItemStack result = FluidUtil.tryPickUpFluid(stack, null, world, blockpos, dispenserFacing.func_176734_d()).getResult();
        if (result.func_190926_b()) {
            return super.func_82487_b(source, stack);
        }

        if (stack.func_190916_E() == 0) {
            stack.deserializeNBT(result.serializeNBT());
        } else if (((TileEntityDispenser) source.func_150835_j()).func_146019_a(result) < 0) {
            this.dispenseBehavior.func_82482_a(source, result);
        }
        stack.func_190918_g(1);
        return stack;
    }

    /**
     * Drains a filled container and places the fluid in front of the Dispenser.
     */
    private ItemStack dumpContainer(IBlockSource source, ItemStack stack) {
        ItemStack dispensedStack = stack.func_77946_l();
        dispensedStack.func_190920_e(1);
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler(dispensedStack);
        if (fluidHandler == null) {
            return super.func_82487_b(source, stack);
        }

        FluidStack fluidStack = fluidHandler.drain(Fluid.BUCKET_VOLUME, false);
        EnumFacing dispenserFacing = source.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);

        if (fluidStack != null && fluidStack.amount == Fluid.BUCKET_VOLUME && FluidUtil.tryPlaceFluid(null, source.func_82618_k(), blockpos, stack.func_77973_b().getContainerItem(stack), fluidStack) != FluidActionResult.FAILURE) {
            if (fluidStack.getFluid() == FluidRegistry.WATER) {
                source.func_82618_k().func_175656_a(blockpos, Blocks.field_150358_i.func_176203_a(2));
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos off = blockpos.func_177972_a(face);
                    if (source.func_82618_k().func_175623_d(off) || source.func_82618_k().func_180495_p(off).func_177230_c()
                            .func_176200_f(source.func_82618_k(), off))
                        source.func_82618_k().func_175656_a(off, Blocks.field_150358_i.func_176203_a(5));
                }
            }

            fluidHandler.drain(Fluid.BUCKET_VOLUME, true);

            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                stack.deserializeNBT(dispensedStack.serializeNBT());
            } else if (((TileEntityDispenser) source.func_150835_j()).func_146019_a(dispensedStack) < 0) {
                this.dispenseBehavior.func_82482_a(source, dispensedStack);
            }

            return stack;
        } else {
            return this.dispenseBehavior.func_82482_a(source, stack);
        }
    }
}
