package betterwithmods.util;

import com.google.common.collect.Lists;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

import java.util.List;
import java.util.Random;

public class DirUtils {

    public static final EnumFacing[] X_AXIS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    public static final EnumFacing[] Y_AXIS = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    public static final EnumFacing[] Z_AXIS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};
    public static final EnumFacing[] NOT_DOWN = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP};
    public static final EnumFacing[][] AXIS_DIRECTIONS = new EnumFacing[][]{X_AXIS, Y_AXIS, Z_AXIS};

    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a("axis", EnumFacing.Axis.class);
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyDirection HORIZONTAL = PropertyDirection.func_177713_a("facing", Lists.newArrayList(EnumFacing.Plane.HORIZONTAL.func_179516_a()));
    public static final PropertyDirection TILTING = PropertyDirection.func_177712_a("facing", facing -> facing != EnumFacing.DOWN);
    public static final PropertyBool UP = PropertyBool.func_177716_a("up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a("down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a("north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a("south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a("west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a("east");
    public static final PropertyBool[] DIR_PROP_HORIZ = new PropertyBool[]{NORTH, SOUTH, WEST, EAST};
    public static final PropertyBool[] DIR_PROP = new PropertyBool[]{DOWN, UP, NORTH, SOUTH, EAST, WEST};

    public static EnumFacing getRandomFacing(List<EnumFacing> validDirections, Random random) {
        return validDirections.get(random.nextInt(validDirections.size()));
    }

    public static void setEntityOrientationFacing(EntityLivingBase entity, EnumFacing side) {
        float pitch = 0.0F;
        float yaw = 0.0F;
        switch (side) {
            case UP:
                pitch = 61.0F;
                break;
            case DOWN:
                pitch = -61.0F;
                break;
            case NORTH:
                yaw = 180.0F;
                break;
            case WEST:
                yaw = 90.0F;
                break;
            case SOUTH:
                yaw = 0.0F;
                break;
            case EAST:
                yaw = -90.0F;
                break;
        }
        entity.field_70177_z = yaw;
        entity.field_70125_A = pitch;
        // entity.setAngles(yaw, pitch);
    }

    public static EnumFacing convertEntityOrientationToFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null)
            return side;
        float pitch = entity.field_70125_A;

        if (pitch > 60.0F)
            return EnumFacing.UP;
        if (pitch < -60.0F)
            return EnumFacing.DOWN;
        return convertEntityOrientationToFlatFacing(entity, side);
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null)
            return side;
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity) {
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        return facing.func_176734_d();
    }

    public static EnumFacing rotateFacingAroundY(EnumFacing facing, boolean reverse) {
        if (facing.ordinal() >= 2) {
            switch (facing) {
                case NORTH:
                    facing = EnumFacing.EAST;
                    break;
                case SOUTH:
                    facing = EnumFacing.WEST;
                    break;
                case WEST:
                    facing = EnumFacing.NORTH;
                    break;
                case EAST:
                    facing = EnumFacing.SOUTH;
                    break;
                default:
                    break;
            }

            if (reverse)
                facing = getOpposite(facing);
        }

        return facing;
    }

    public static EnumFacing.Axis getAxis(int axis) {
        return EnumFacing.Axis.values()[axis];
    }

    public static BlockPos movePos(BlockPos source, EnumFacing facing) {
        return source.func_177971_a(facing.func_176730_m());

    }

    public static EnumFacing[] getAxisDirection(EnumFacing.Axis axis) {
        return AXIS_DIRECTIONS[axis.ordinal()];
    }

}

