package betterwithmods.util;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;

/**
 * Hack class to allow multiple bounding boxes per entity.
 *
 * @author mrebhan
 */

public class AABBArray extends AxisAlignedBB {

    private AxisAlignedBB[] boundingBoxes;

    public AABBArray(AxisAlignedBB... boundingBoxes) {
        this(join(boundingBoxes));
        this.boundingBoxes = boundingBoxes;
        this.boundingBoxes = getParts(this);
    }

    private AABBArray(AxisAlignedBB full) {
        super(full.field_72340_a, full.field_72338_b, full.field_72339_c, full.field_72336_d, full.field_72337_e, full.field_72334_f);
    }

    private static AxisAlignedBB join(AxisAlignedBB[] in) {
        if (in.length == 0) {
            return null;
        }

        AxisAlignedBB aabb1 = in[0];
        for (int i = 1; i < in.length; i++) {
            aabb1 = aabb1.func_111270_a(in[i]);
        }
        return aabb1;
    }

    public static AxisAlignedBB[] getParts(AxisAlignedBB source) {
        if (source instanceof AABBArray) {
            HashSet<AxisAlignedBB> bbs = new HashSet<>();
            Arrays.asList(((AABBArray) source).boundingBoxes)
                    .forEach(aabb -> bbs.addAll(Arrays.asList(getParts(aabb))));
            return bbs.toArray(new AxisAlignedBB[0]);
        }
        return new AxisAlignedBB[]{source};
    }

    public static AxisAlignedBB toAABB(AxisAlignedBB source) {
        return new AxisAlignedBB(source.field_72340_a, source.field_72338_b, source.field_72339_c, source.field_72336_d, source.field_72337_e, source.field_72334_f);
    }

    @Override
    public boolean func_189973_a(Vec3d p_189973_1_, Vec3d p_189973_2_) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : boundingBoxes) {
            flag |= axisAlignedBB.func_189973_a(p_189973_1_, p_189973_2_);
        }
        return flag;
    }

    @Override
    public boolean func_186668_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186668_a(x1, y1, z1, x2, y2, z2);
        }
        return flag;
    }

    public AABBArray addBoundingBox(AxisAlignedBB aabb) {
        AxisAlignedBB[] bbs = new AxisAlignedBB[boundingBoxes.length + 1];
        bbs[bbs.length] = aabb;
        return new AABBArray(bbs);
    }

    @Override
    public AABBArray func_72317_d(double x, double y, double z) {
        AxisAlignedBB[] parts = getParts(this);
        for (int i = 0; i < parts.length; i++) {
            parts[i] = parts[i].func_72317_d(x, y, z);
        }
        return new AABBArray(parts);
    }

    @Override
    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        for (AxisAlignedBB axisAlignedBB : boundingBoxes) {
            offsetX = axisAlignedBB.func_72316_a(other, offsetX);
        }
        return offsetX;
    }

    @Override
    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        for (AxisAlignedBB axisAlignedBB : boundingBoxes) {
            offsetY = axisAlignedBB.func_72323_b(other, offsetY);
        }
        return offsetY;
    }

    @Override
    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        for (AxisAlignedBB axisAlignedBB : boundingBoxes) {
            offsetZ = axisAlignedBB.func_72322_c(other, offsetZ);
        }
        return offsetZ;
    }

    public boolean intersectsWithXY(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186668_a(other.field_72340_a, other.field_72338_b, Double.NEGATIVE_INFINITY, other.field_72336_d, other.field_72337_e,
                    Double.POSITIVE_INFINITY);
        }
        return flag;
    }

    public boolean intersectsWithXZ(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186668_a(other.field_72340_a, Double.NEGATIVE_INFINITY, other.field_72339_c, other.field_72336_d,
                    Double.POSITIVE_INFINITY, other.field_72334_f);
        }
        return flag;
    }

    public boolean intersectsWithYZ(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186668_a(Double.NEGATIVE_INFINITY, other.field_72338_b, other.field_72339_c, Double.POSITIVE_INFINITY,
                    other.field_72337_e, other.field_72334_f);
        }
        return flag;
    }

    @Override
    public boolean func_72326_a(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : boundingBoxes) {
            flag |= axisAlignedBB.func_72326_a(other);
        }
        return flag;
    }

    @Override
    public boolean func_72318_a(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_72318_a(vec);
        }
        return flag;
    }

    @Override
    public boolean func_186669_d(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186669_d(vec);
        }
        return flag;
    }

    @Override
    public boolean func_186667_c(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186667_c(vec);
        }
        return flag;
    }

    @Override
    public boolean func_186660_b(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            flag |= axisAlignedBB.func_186660_b(vec);
        }
        return flag;
    }

    @Override
    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        if (x == 0 && y == 0 && z == 0) {
            return new AABBArray(boundingBoxes);
        }
        return super.func_72314_b(x, y, z);
    }

    @Override
    public AxisAlignedBB func_186662_g(double value) {
        return this.func_72314_b(value, value, value);
    }

    @Override
    public RayTraceResult func_72327_a(Vec3d vecA, Vec3d vecB) {
        RayTraceResult result = null;
        for (AxisAlignedBB axisAlignedBB : getParts(this)) {
            result = axisAlignedBB.func_72327_a(vecA, vecB);
            if (result != null) {
                break;
            }
        }
        return result;
    }

    public AABBArray forEach(Function<AxisAlignedBB, AxisAlignedBB> consumer) {
        AxisAlignedBB[] var1 = getParts(this);
        for (int i = 0; i < var1.length; i++) {
            var1[i] = consumer.apply(var1[i]);
        }

        return new AABBArray(var1);
    }

    // to implement

    @Override
    public AxisAlignedBB func_72321_a(double x, double y, double z) {
        return super.func_72321_a(x, y, z);
    }

    @Override
    public AxisAlignedBB func_186664_h(double value) {
        return super.func_186664_h(value);
    }

    @Override
    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return super.func_186670_a(pos);
    }

    @Override
    public AxisAlignedBB func_186666_e(double y2) {
        return super.func_186666_e(y2);
    }

    @Override
    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        return super.func_111270_a(other);
    }

}
