package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.awt.*;
import java.util.Random;

public class VisibleStorms extends Feature {
    public static boolean DUST_STORMS;
    public static boolean SAND_STORMS;
    public static int DUST_PARTICLES;
    public static int AIR_PARTICLES;

    @Override
    public void setupConfig() {
        DUST_STORMS = loadPropBool("Dust Storms","Storms are clearly visible in dry biomes.",true);
        SAND_STORMS = loadPropBool("Sand Storms","Adds a fog change during storms in deserts.",true);
        DUST_PARTICLES = loadPropInt("Dust Particle Count","How many dust particles should be created, too many may contribute to lag.",2);
        AIR_PARTICLES = loadPropInt("Air Particle Count","How many air particles should be created, too many may contribute to lag.",3);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    float currentRed, currentGreen, currentBlue;
    float currentDistance, currentDistanceScale;
    float desiredRed, desiredGreen, desiredBlue;
    float desiredDistance, desiredDistanceScale;

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent tickEvent) {
        EntityPlayer entity = tickEvent.player;
        if (entity == null)
            return;
        World world = entity.field_70170_p;
        if (world == null || !world.field_72995_K)
            return;
        if (DUST_STORMS) {
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;

            Random random = world.field_73012_v;
            BlockPos pos = entity.func_180425_c();
            int radius = 16; //blocks
            for (int i = 0; i < DUST_PARTICLES; i++) {
                BlockPos posGround = pos.func_177982_a(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (!shouldStorm(world, posGround))
                    continue;
                posGround = world.func_175645_m(posGround).func_177977_b(); //Constant access whaaaat???

                IBlockState stateGround = world.func_180495_p(posGround);
                Particle particleGround = particleManager.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), posGround.func_177958_n() + random.nextDouble(), posGround.func_177956_o() + 1.2, posGround.func_177952_p() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0, Block.func_176210_f(stateGround));
            }

            for (int i = 0; i < AIR_PARTICLES; i++) {
                BlockPos posAir = pos.func_177982_a(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (world.func_175678_i(posAir) && shouldStorm(world, posAir)) {
                    Particle particleAir = particleManager.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), posAir.func_177958_n() + random.nextDouble(), posAir.func_177956_o() + random.nextDouble(), posAir.func_177952_p() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0);
                    if(particleAir != null)
                        particleAir.func_70538_b(1.0f, 1.0f, 1.0f);
                }
            }
        }

        if (SAND_STORMS) {
            float epsilon = 0.001f;
            if (Math.abs(currentDistance - desiredDistance) > epsilon)
                currentDistance += (desiredDistance - currentDistance) * 0.2; //TODO: We can do better.
            if (Math.abs(currentDistanceScale - desiredDistanceScale) > epsilon)
                currentDistanceScale += (desiredDistanceScale - currentDistanceScale) * 0.2; //TODO: We can do better.
            if (Math.abs(currentRed - desiredRed) > epsilon)
                currentRed += (desiredRed - currentRed) * 0.2;
            if (Math.abs(currentGreen - desiredGreen) > epsilon)
                currentGreen += (desiredGreen - currentGreen) * 0.2;
            if (Math.abs(currentBlue - desiredBlue) > epsilon)
                currentBlue += (desiredBlue - currentBlue) * 0.2;
        }
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void fogDistance(EntityViewRenderEvent.RenderFogEvent fogEvent) {
        if (!SAND_STORMS)
            return;
        Entity entity = fogEvent.getEntity();
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_180425_c();

        if (world.func_72896_J()) {
            desiredDistance = 0;
            desiredDistanceScale = 0;
            int totalweight = 0;
            BlockPos[] probes = new BlockPos[]{pos, pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1)};
            for (BlockPos probepos : probes) {
                boolean aboveground = world.func_175678_i(probepos);
                if (isDesert(world, probepos) && aboveground) {
                    desiredDistance += fogEvent.getFarPlaneDistance() / 3f;
                    desiredDistanceScale += -1.0f;
                    totalweight += 1;
                } else if (aboveground) {
                    desiredDistance += fogEvent.getFarPlaneDistance();
                    desiredDistanceScale += 0.75f;
                    totalweight += 1;
                }
            }
            desiredDistance /= totalweight;
            desiredDistanceScale /= totalweight;
        } else {
            desiredDistance = fogEvent.getFarPlaneDistance();
            desiredDistanceScale = 0.75F;
        }

        if (Math.abs(fogEvent.getFarPlaneDistance() - currentDistance) > 0.001f)
            renderFog(fogEvent.getFogMode(), currentDistance, currentDistanceScale);

        //renderFog(fogEvent.getFogMode(),fogEvent.getFarPlaneDistance(),-1.0f);
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void fogColor(EntityViewRenderEvent.FogColors fogEvent) {
        if (!SAND_STORMS)
            return;
        Entity entity = fogEvent.getEntity();
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_180425_c();
        Color desiredcolor = new Color(
                Math.min(fogEvent.getRed(),1.0f),
                Math.min(fogEvent.getGreen(),1.0f),
                Math.min(fogEvent.getBlue(),1.0f)
        );

        if (world.func_72896_J()) {
            float red = 0;
            float green = 0;
            float blue = 0;
            int totalweight = 0;
            BlockPos[] probes = new BlockPos[]{pos, pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1)};
            for (BlockPos probepos : probes) {
                boolean aboveground = world.func_175678_i(probepos);
                if (isDesert(world, probepos)) {
                    Biome biome = world.func_180494_b(probepos);
                    MapColor mapcolor = biome.field_76752_A.func_185909_g(world,probepos);
                    Color color = new Color(mapcolor.field_76291_p);
                    red += 2 * (color.getRed() / 255.0f);
                    green += 2 * (color.getGreen() / 255.0f);
                    blue += 2 * (color.getBlue() / 255.0f);
                    totalweight += 2;
                } else if (aboveground) {
                    red += fogEvent.getRed();
                    green += fogEvent.getGreen();
                    blue += fogEvent.getBlue();
                    totalweight += 1;
                }
            }
            desiredcolor = new Color(Math.min(red / totalweight,1.0f), Math.min(green / totalweight,1.0f), Math.min(blue / totalweight,1.0f));
            fogEvent.setRed(currentRed / 255.0f);
            fogEvent.setGreen(currentGreen / 255.0f);
            fogEvent.setBlue(currentBlue / 255.0f);
        }

        desiredRed = desiredcolor.getRed();
        desiredGreen = desiredcolor.getGreen();
        desiredBlue = desiredcolor.getBlue();
    }

    private boolean shouldStorm(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);

        return world.func_72896_J() && !biome.func_76738_d() && !biome.func_150559_j();
    }

    private boolean isDesert(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);

        return BiomeDictionary.hasType(biome, BiomeDictionary.Type.SANDY);
    }

    @SideOnly(Side.CLIENT)
    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GlStateManager.func_179102_b(0.0F);
            GlStateManager.func_179153_c(farPlaneDistance);
        } else {
            GlStateManager.func_179153_c(farPlaneDistance);
            GlStateManager.func_179102_b(farPlaneDistance * farPlaneDistanceScale);
        }
    }
}
