package betterwithmods.module.tweaks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.module.Feature;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Notes extends Feature {

    @Override
    public String getFeatureDescription() {
        return "Add some notes to the Note Block. Try a companion cube under one";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onNotePlay(NoteBlockEvent.Play event) {
        BlockPos pos = event.getPos();
        if (event.getWorld().func_180495_p(pos).func_177230_c() != Blocks.field_150323_B)
            return;

        int type = getType(event.getWorld(), pos);
        if (type != -1 && type != 3) {
            event.setCanceled(true);

            SoundEvent sound = null;
            switch (type) {
                case 1:
                    sound = SoundEvents.field_187857_gE;

            }

            if (sound != null) {
                float pitch = (float) Math.pow(2.0, (event.getVanillaNoteId() - 12) / 12.0);
                event.getWorld().func_184148_a(null, pos.func_177958_n() + 0.5, pos.func_177956_o() + 1.5, pos.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 1F, pitch);
            }
        }
    }

    private int getType(World world, BlockPos pos) {
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        if (down.func_177230_c() == BWMBlocks.WOLF)
            return 1;
        return 0;
    }
}
