package betterwithmods.module.tweaks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockMushroom;
import betterwithmods.module.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.HashSet;

public class MushroomFarming extends Feature {
    public static boolean ALIAS_MUSHROOMS;
    public static boolean SPREAD_ON_MYCELLIUM;
    public static boolean GROW_FAST_ON_DUNG;
    public static int MAX_LIGHT_LEVEL_RED;
    public static int MAX_LIGHT_LEVEL_BROWN;
    public static int MAX_LIGHT_LEVEL_MISC;
    public static HashSet<String> MISC_MUSHROOMS;

    public static Block RED_MUSHROOM;
    public static Block BROWN_MUSHROOM;

    @Override
    public void setupConfig() {
        MAX_LIGHT_LEVEL_BROWN = loadPropInt("Maximum Light Level Brown", "The highest lightlevel at which brown mushrooms will grow.", 0);
        MAX_LIGHT_LEVEL_RED = loadPropInt("Maximum Light Level Red", "The highest lightlevel at which red mushrooms will grow.", 12);
        MAX_LIGHT_LEVEL_MISC = loadPropInt("Maximum Light Level Misc", "The highest lightlevel at which other mushrooms (see Valid Other Mushrooms) will grow.", 0);
        MISC_MUSHROOMS = loadPropStringHashSet("Valid Other Mushrooms","Registry names of affected mushrooms other than vanilla ones.",new String[]{});
        SPREAD_ON_MYCELLIUM = loadPropBool("Spread On Mycellium","Whether mushrooms can spread on mycellium even at a higher light level",false);
        GROW_FAST_ON_DUNG = loadPropBool("Grow Faster On Dung","Whether mushrooms grow faster on dung blocks",false);
        ALIAS_MUSHROOMS = loadPropBool("Alias Mushrooms","Aliases vanilla mushrooms to truly prevent them from growing. Turn this off if it causes conflicts.",true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if(ALIAS_MUSHROOMS) {
            RED_MUSHROOM = new BlockMushroom(MAX_LIGHT_LEVEL_RED).setRegistryName("minecraft:red_mushroom");
            BROWN_MUSHROOM = new BlockMushroom(MAX_LIGHT_LEVEL_BROWN).setRegistryName("minecraft:brown_mushroom");
            BWMBlocks.registerBlock(RED_MUSHROOM,null);
            BWMBlocks.registerBlock(BROWN_MUSHROOM,null);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Blocks.field_150338_P.func_149715_a(0);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Brown mushrooms can only be farmed in complete darkness.";
    }

    @SubscribeEvent(priority = EventPriority.HIGHEST)
    public void placeMushroom(BlockEvent.PlaceEvent event)
    {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getPlacedBlock();

        if(isMushroom(state) && !canGrowMushroom(world,pos))
        {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void neighborUpdate(BlockEvent.NeighborNotifyEvent event)
    {
        World world = event.getWorld();
        BlockPos pos = event.getPos();

        if(!world.field_72995_K)
        {
            popOffMushroom(world,pos);
            popOffMushroom(world,pos.func_177984_a());
        }
    }

    private boolean isMushroom(IBlockState state)
    {
        ResourceLocation loc = state.func_177230_c().getRegistryName();
        if(loc == null) //WEE WOO WEE WOO
            throw new IllegalStateException("BetterWithMods Handler ("+this.getClass().getSimpleName()+") obtained an unregistered block from a blockstate! (Block -> "+state.func_177230_c().getClass().getName()+")");
        return MISC_MUSHROOMS.contains(loc.toString());
    }

    private void popOffMushroom(World world, BlockPos pos)
    {
        IBlockState state = world.func_180495_p(pos);
        if(isMushroom(state) && !canGrowMushroom(world,pos))
        {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean canGrowMushroom(World world,BlockPos pos)
    {
        int light = world.func_175699_k(pos);
        IBlockState soil = world.func_180495_p(pos.func_177977_b());

        return light <= MAX_LIGHT_LEVEL_MISC || isMushroomSoil(soil);
    }

    public static boolean isMushroomSoil(IBlockState state)
    {
        if (state.func_177230_c() == Blocks.field_150391_bh)
            return true;
        else if (state.func_177230_c() == Blocks.field_150346_d && state.func_177229_b(BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL)
            return true;
        return false;
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if(event.getState().func_177230_c() instanceof BlockMushroom) {
            event.getDrops().clear();
            event.getDrops().add(BWMRecipes.getStackFromState(event.getState()));
        }
    }
}
