package betterwithmods.module.tweaks;

import betterwithmods.common.entity.EntityJungleSpider;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.BlockMaterialIngredient;
import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

import java.util.Iterator;
import java.util.List;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class MobSpawning extends Feature {
    public static final SpawnWhitelist NETHER = new SpawnWhitelist();
    public static final SpawnWhitelist SLIME = new SpawnWhitelist();
    
    private boolean slime;
    private boolean nether;
    private boolean witches;
    private boolean jungleSpiders;

    @Override
    public void init(FMLInitializationEvent event) {
        if (nether) {
            NETHER.addBlock(Blocks.field_150424_aL);
            NETHER.addBlock(Blocks.field_150385_bj);
            NETHER.addBlock(Blocks.field_150425_aM);
            NETHER.addBlock(Blocks.field_150351_n);
            NETHER.addBlock(Blocks.field_150371_ca);
        }

        if (slime) {
            SLIME.addIngredient(new BlockMaterialIngredient(Material.field_151577_b, Material.field_151576_e, Material.field_151578_c));
        }

        Iterator<Biome> iterator = Biome.field_185377_q.iterator();
        while (iterator.hasNext()) {
            Biome biome = iterator.next();
            if (jungleSpiders && BiomeDictionary.hasType(biome, BiomeDictionary.Type.JUNGLE))
                EntityRegistry.addSpawn(EntityJungleSpider.class, 100, 1, 3, EnumCreatureType.MONSTER, biome);
            if (witches && !BiomeDictionary.hasType(biome, BiomeDictionary.Type.SWAMP))
                EntityRegistry.removeSpawn(EntityWitch.class, EnumCreatureType.MONSTER, biome);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Nether Mobs can only spawn on nether blocks and Slimes can only spawn on natural blocks. Also adjusts whether witches only spawn in swamps and if jungle spiders spawn in jungles.";
    }

    @Override
    public void setupConfig() {
        slime = loadPropBool("Limit Slime Spawning", "Slimes can only spawn on natural blocks", true);
        nether = loadPropBool("Limit Nether Spawning", "Nether Mobs can only spawn on nether blocks", true);
        witches = loadPropBool("Limit Witch Spawning", "Witches can only spawn in swamps", true);
        jungleSpiders = loadPropBool("Jungle Spider Spawning", "Jungle Spiders can spawn in jungles", true);
    }

    @SubscribeEvent
    public void denySlimeSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW)
            return;
        if (!slime)
            return;
        World world = event.getWorld();
        if (world != null && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            if (event.getEntityLiving() instanceof EntitySlime) {
                BlockPos pos = new BlockPos(event.getEntity().field_70165_t, event.getEntity().field_70163_u - 1, event.getEntity().field_70161_v);
                if (!SLIME.contains(world, pos, world.func_180495_p(pos)))
                    event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void denyNetherSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW)
            return;
        if (!nether)
            return;
        World world = event.getWorld();
        if (world != null && world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
            if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
                double monX = event.getEntity().field_70165_t;
                double monY = event.getEntity().field_70163_u;
                double monZ = event.getEntity().field_70161_v;
                int x = MathHelper.func_76128_c(monX);
                int y = MathHelper.func_76128_c(monY);
                int z = MathHelper.func_76128_c(monZ);
                BlockPos pos = new BlockPos(x, y - 1, z);
                IBlockState state = world.func_180495_p(pos);
                if (!world.func_175623_d(pos) && !NETHER.contains(world, pos, state))
                    event.setResult(Event.Result.DENY);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static class SpawnWhitelist {
        private final List<BlockIngredient> WHITELIST = Lists.newArrayList();

        public void addIngredient(BlockIngredient ingredient) {
            WHITELIST.add(ingredient);
        }

        public void addBlock(Block block) {
            WHITELIST.add(new BlockIngredient(Ingredient.func_193367_a(Item.func_150898_a(block))));
        }

        public void addBlock(ItemStack stack) {
            WHITELIST.add(new BlockIngredient(stack));
        }

        public boolean contains(World world, BlockPos pos, IBlockState state) {
            return WHITELIST.stream().anyMatch(i -> i.apply(world, pos, state));
        }
    }

}
