package betterwithmods.module.tweaks;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWRegistry;
import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

import java.util.List;


/**
 * Created by primetoxinz on 5/16/17.
 */
public class KilnCharcoal extends Feature {

    private static final ItemStack CHARCOAL = new ItemStack(Items.field_151044_h, 1, 1);
    private boolean disableFurnaceCharcoal;

    @Override
    public void setupConfig() {
        disableFurnaceCharcoal = loadPropBool("Disable Furnace Charcoal", "Remove recipes to make Charcoal in a Furnace", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Add Charcoal smelting to the Kiln";
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        List<ItemStack> logs = Lists.newArrayList();
        logs.addAll(OreDictionary.getOres("logWood"));

        for (ItemStack stack : logs) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemStack charcoalOutput = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                if (charcoalOutput.func_190926_b())
                    continue;
                if (disableFurnaceCharcoal)
                    BWMRecipes.removeFurnaceRecipe(stack);
                BWRegistry.KILN.addStokedRecipe(stack,charcoalOutput);
            }
        }
    }


}
