package betterwithmods.module.tweaks;

import betterwithmods.common.entity.ai.EntityAIFlee;
import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class ImprovedFlee extends Feature {

    private static boolean blockPlace, blockBreak, groupFlee;

    public static boolean canSeeBlock(BlockPos pos, EntityLiving entity) {
        RayTraceResult result = entity.field_70170_p.func_72933_a(entity.func_174791_d(), new Vec3d(pos).func_72441_c(0.5,0.5,0.5));
        return result != null && pos.equals(result.func_178782_a());
    }

    @Override
    public void setupConfig() {
        blockPlace = loadPropBool("Animals Flee from Block Place", "When a block is placed in the vicinity of an animal it will get scared and run.", true);
        blockBreak = loadPropBool("Animals Flee from Block Break", "When a non-replaceable block is broken in the vicinity of an animal it will get scared and run.", true);
        groupFlee = loadPropBool("Animals Group Flee", "When an animal is attacked in the vicinity of another animal it will get scared and run.", true);
    }

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof EntityLiving) {
            EntityLiving entity = (EntityLiving) evt.getEntity();
            if (entity instanceof EntityAnimal && EntityUtils.hasAI(entity, EntityAIPanic.class)) {
                float speed = (float) entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 7;
                EntityUtils.removeAI(entity, EntityAIPanic.class);
                entity.field_70714_bg.func_75776_a(0, new EntityAIFlee((EntityCreature) entity, speed));
            }
        }
    }


    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        if (!blockPlace)
            return;
        if (event.getPlayer() != null) {
            AxisAlignedBB box = event.getPlacedBlock().func_185900_c(event.getWorld(), event.getPos()).func_186670_a(event.getPos()).func_186662_g(10);
            for (EntityAnimal animal : event.getWorld().func_72872_a(EntityAnimal.class, box)) {
                if (cantBeScared(animal)) continue;
                if (canSeeBlock(event.getPos(), animal))
                    animal.func_70604_c(event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!blockBreak)
            return;
        if (event.getPlayer() != null && !event.getState().func_185904_a().func_76222_j()) {
            AxisAlignedBB box = event.getState().func_185900_c(event.getWorld(), event.getPos()).func_186670_a(event.getPos()).func_186662_g(10);
            for (EntityAnimal animal : event.getWorld().func_72872_a(EntityAnimal.class, box)) {
                if (cantBeScared(animal)) continue;
                if (canSeeBlock(event.getPos(), animal))
                    animal.func_70604_c(event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onGroupFlee(LivingSetAttackTargetEvent event) {
        if (!groupFlee)
            return;
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityAnimal) {
            EntityAnimal a = (EntityAnimal) event.getEntityLiving();
            AxisAlignedBB box = new AxisAlignedBB(a.field_70165_t, a.field_70163_u, a.field_70161_v, a.field_70165_t + 1, a.field_70163_u + 1, a.field_70161_v + 1).func_186662_g(10);
            for (EntityAnimal animal : a.func_130014_f_().func_175647_a(EntityAnimal.class, box, entity -> entity != null && entity != a && entity.func_70643_av() == null)) {
                if (cantBeScared(animal)) continue;
                if (animal.func_70685_l(a)) {
                    animal.func_70604_c(event.getTarget());
                }
            }
        }
    }

    private boolean cantBeScared(EntityAnimal animal) {
        if (animal instanceof EntityTameable && ((EntityTameable) animal).func_70909_n())
            return true;
        if (animal instanceof AbstractHorse && ((AbstractHorse) animal).func_110248_bS())
            return true;
        if (!EntityUtils.hasAI(animal, EntityAIFlee.class))
            return true;
        return false;
    }

    @Override
    public String getFeatureDescription() {
        return "Improve fleeing AI for attacked animals";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}
