package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.List;

import static betterwithmods.module.hardcore.needs.HCMovement.dirtpathQuality;

public class GrassPath extends Feature {
    public static List<ItemStack> SHOVEL_BLACKLIST = Lists.newArrayList();

    public static int getShovelQuality(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!item.getToolClasses(stack).contains("shovel"))
            return -1;
        if (!dirtpathQuality) {
            return 3;
        } else {
            return item.getHarvestLevel(stack, "shovel", null, null);
        }
    }

    @Override
    public void setupConfig() {
        SHOVEL_BLACKLIST = loadItemStackList("Shovel Blacklist", "Blacklist an item for being able to make grass paths", new String[]{"psi:cad"});
    }

    @Override
    public String getFeatureDescription() {
        return "Allows turning more than just grass into path. Turns off when dirt2path is installed";
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"dirt2path"};
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    protected boolean isBlockDirt(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150349_c;
    }

    protected void setPathOrDirt(World world, IBlockState blockState, BlockPos blockPos, SoundEvent soundEvent, EntityPlayer player, ItemStack itemStack, EnumHand hand) {
        world.func_184133_a(player, blockPos, soundEvent, SoundCategory.BLOCKS, 1.0F, 1.0F);
        player.func_184609_a(hand);
        if (!world.field_72995_K) {
            world.func_180501_a(blockPos, blockState, 11);
            itemStack.func_77972_a(1, player);
        }
    }


    @SubscribeEvent(priority = EventPriority.LOWEST)
    public void onBlockRightclick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled())
            return;

        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        ItemStack stack = player.func_184586_b(event.getHand());

        IBlockState iBlockState = world.func_180495_p(blockPos);

        if (stack.func_190926_b() || !isBlockDirt(iBlockState))
            return;

        int quality = getShovelQuality(stack);
        if (quality == -1)
            return;
        if (quality < 2) {
            event.setCanceled(true);
            return;
        }

        if (world.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            if (isBlockDirt(iBlockState)) {
                IBlockState pathState = Blocks.field_185774_da.func_176223_P();
                setPathOrDirt(world, pathState, blockPos, SoundEvents.field_187771_eN, player, stack, event.getHand());
            }
        }
    }

}
