package betterwithmods.module.tweaks;

import betterwithmods.common.BWMItems;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.module.Feature;
import betterwithmods.util.EntityUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class CreeperShearing extends Feature {

    public static ResourceLocation CREEPER = new ResourceLocation("minecraft","creeper");

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if(EntityList.func_180123_a(entity, CREEPER)) {
            double chance = entity.func_70681_au().nextDouble() + (0.1 * event.getLootingLevel());
            if (chance <= 0.05) {
                WorldUtils.addDrop(event,new ItemStack(BWMItems.CREEPER_OYSTER));
            }
        }
    }

    @SubscribeEvent
    public void shearCreeper(PlayerInteractEvent.EntityInteractSpecific e) {
        if (e.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase creeper = (EntityLivingBase) e.getTarget();
            if(EntityList.func_180123_a(creeper, CREEPER)) {
                if (e.getSide().isServer() && creeper.func_70089_S() && !e.getItemStack().func_190926_b()) {
                    Item item = e.getItemStack().func_77973_b();
                    if (item instanceof ItemShears) {
                        if(e.getEntityPlayer().func_184811_cZ().func_185141_a(item))
                            return;
                        e.getEntityPlayer().func_184811_cZ().func_185145_a(item, 20);
                        e.getItemStack().func_77972_a(1,e.getEntityLiving());
                        InvUtils.ejectStack(e.getWorld(), creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, new ItemStack(BWMItems.CREEPER_OYSTER));
                        EntityShearedCreeper shearedCreeper = new EntityShearedCreeper(e.getWorld());
                        creeper.func_70097_a(new DamageSource(""), 0);
                        EntityUtils.copyEntityInfo(creeper, shearedCreeper);
                        e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187882_fq, SoundCategory.HOSTILE, 1, 0.3F);
                        e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187763_eJ, SoundCategory.HOSTILE, 1, 1F);
                        creeper.func_70106_y();
                        e.getWorld().func_72838_d(shearedCreeper);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Shearing a Creeper will removes its ability to explode, making him very sad";
    }
}
