package betterwithmods.module.hardcore.world;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.world.BWComponentScatteredFeaturePieces;
import betterwithmods.common.world.BWMapGenScatteredFeature;
import betterwithmods.module.Feature;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class HCStructures extends Feature {
    public static int HARDCORE_STRUCTURE_RADIUS;
    private boolean disableRecipes;

    public static boolean isInRadius(World world, int x, int z) {
        BlockPos center = world.func_175694_M();
        return Math.sqrt(Math.pow(x - center.func_177958_n(), 2) + Math.pow(z - center.func_177952_p(), 2)) < HARDCORE_STRUCTURE_RADIUS;
    }

    @Override
    public String getFeatureDescription() {
        return "Makes it so structures are looted within a radius of spawn and unlooted outside of that radius. \nEncourages exploration.\nHC" +
                "Also makes unlooted structures the only source of Enchanting Tables and Brewing Stands.";
    }

    @Override
    public void setupConfig() {
        HARDCORE_STRUCTURE_RADIUS = loadPropInt("Hardcore Structure Radius", "Radius from original spawn which structures will be abandoned in", 2000);
        disableRecipes = loadPropBool("Disable Recipes", "Disable Recipes for blocks that generate only in structures, including Enchanting Tables and Brewing Stands", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (disableRecipes) {
            BWMRecipes.removeRecipe(new ItemStack(Blocks.field_150381_bn));
            BWMRecipes.removeRecipe(new ItemStack(Items.field_151067_bt));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MapGenStructureIO.func_143034_b(BWMapGenScatteredFeature.Start.class, "BWTemple");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.DesertPyramid.class, "BWTeDP");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.JunglePyramid.class, "BWTeJP");
        MapGenStructureIO.func_143031_a(BWComponentScatteredFeaturePieces.SwampHut.class, "BWTeSH");
        //MapGenStructureIO.registerStructureComponent(BWComponentScatteredFeaturePieces.Igloo.class, "BWIglu");
    }

    @SubscribeEvent
    public void overrideScatteredFeature(InitMapGenEvent event) {
        if (event.getType().equals(InitMapGenEvent.EventType.SCATTERED_FEATURE))
            event.setNewGen(new BWMapGenScatteredFeature());
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }
}
