package betterwithmods.module.hardcore.world;

import betterwithmods.BWMod;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.FluidUtils;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.*;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.List;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class HCBuckets extends Feature {
    private static List<String> fluidWhitelist;
    private static List<ResourceLocation> fluidcontainerBacklist;
    private static List<Integer> dimensionBlacklist;

    @Override
    public String getFeatureDescription() {
        return "Makes it so water buckets cannot move an entire source block, making water a more valuable resource";
    }

    @Override
    public void setupConfig() {
        dimensionBlacklist = Ints.asList(loadPropIntList("Dimension Black List", "A List of dimension ids in which water buckets will work normally. This is done in the End by default to make Enderman Farms actually reasonable to create.", new int[]{DimensionType.THE_END.func_186068_a()}));
        fluidWhitelist = Lists.newArrayList(loadPropStringList("Fluid Whitelist", "List of fluids that will be handled by HCBuckets.", new String[]{
                FluidRegistry.WATER.getName(),
                "swamp_water",
                "milk",
                "stagnant_water",
                "acid",
                "sludge",
                "ale",
                "alewort",
                "applejuice",
                "cider",
                "grapejuice",
                "honey",
                "ironberryjuice",
                "ironwine",
                "mead",
                "oliveoil",
                "wildberryjuice",
                "wildberrywine",
                "wine",
                "blood",
                "purpleslime",
        }));
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        //TODO dispenser behavior; for water and lava bucket

        fluidcontainerBacklist = ConfigHelper.loadPropRLList("Fluid container blacklist", configCategory, "Blacklist itemstacks from being effected by HCBuckets", new String[]{
                "thermalcultivation:watering_can"
        });
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }


    @SubscribeEvent
    public void onInteractFluidHandlerItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler(stack);
        if (handlerItem != null) {
            //Don't need to do buckets
            if (stack.func_77973_b() instanceof ItemBucket)
                return;
            
            if (fluidcontainerBacklist.contains(stack.func_77973_b().getRegistryName()))
                return;

            FluidStack contained = FluidUtil.getFluidContained(stack);

            RayTraceResult raytraceresult = stack.func_77973_b().func_77621_a(event.getWorld(), event.getEntityPlayer(), contained == null);

            ActionResult<ItemStack> actionResult = ForgeEventFactory.onBucketUse(event.getEntityPlayer(), event.getWorld(), stack, raytraceresult);
            if (actionResult != null && actionResult.func_188397_a() == EnumActionResult.SUCCESS) {
                if (stack != actionResult.func_188398_b()) {
                    event.getEntityPlayer().func_184611_a(event.getHand(), actionResult.func_188398_b());
                    event.setCanceled(true);
                }
            }
        }
    }


    @SubscribeEvent(priority = EventPriority.HIGHEST)
    public void onUseFluidContainer(FillBucketEvent event) {
        if (event.isCanceled()) return;
        if (event.getTarget() != null) {
            ItemStack container = event.getEmptyBucket();
            RayTraceResult raytraceresult = event.getTarget();
            BlockPos pos = raytraceresult.func_178782_a();
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            if (!PlayerHelper.isSurvival(player))
                return;


            //Skip blacklisted fluidcontainers
            if (fluidcontainerBacklist.contains(container.func_77973_b().getRegistryName()))
                return;

            FluidStack fluidStack = FluidUtil.getFluidContained(container);
            //Ignore blacklisted dimensions
            if (dimensionBlacklist.contains(world.field_73011_w.getDimension()))
                return;

            //Only use whitelisted fluids.
            if (fluidStack != null && !fluidWhitelist.contains(fluidStack.getFluid().getName())) {
                return;
            }

            //Attempt to pick up a BlockFluidBase or BlockLiquidBase using our custom wrappers.
            FluidActionResult result = FluidUtils.tryPickUpFluid(container, player, world, pos, raytraceresult.field_178784_b);


            if (result.isSuccess()) {
                if (player.func_184811_cZ().func_185141_a(container.func_77973_b())) {
                    event.setCanceled(true);
                    return;
                }

                ItemStack filledContainer = result.getResult();
                FluidStack filledFluidStack = FluidUtil.getFluidContained(filledContainer);

                if (filledFluidStack != null && !fluidWhitelist.contains(filledFluidStack.getFluid().getName())) {
                    event.setResult(Event.Result.DENY);
                    return;
                }

                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(result.getResult());
                //Add a cool down so you cannot pickup fluid from small puddle made when dumping it.
                //(Stops you from using a single bucket to traverse a lava pool)
                player.func_184811_cZ().func_185145_a(container.func_77973_b(), 20);
            } else {
                //No fluid was found, try to place one instead
                BlockPos offset = pos.func_177972_a(raytraceresult.field_178784_b);
                IBlockState state = world.func_180495_p(offset);
                if (state.func_185904_a().func_76222_j()) {

                    if (fluidStack != null) {
                        if (fluidStack.amount == Fluid.BUCKET_VOLUME) {
                            //Try to place the fluid using our custom wrappers again, does not create a source block.
                            FluidActionResult placeResult = FluidUtils.tryPlaceFluid(player, world, offset, container, fluidStack);
                            if (placeResult.isSuccess()) {
                                event.setResult(Event.Result.ALLOW);
                                event.setFilledBucket(placeResult.getResult());
                            }
                        }
                    }
                } else if (!state.func_185904_a().func_76218_k()) {
                    //Can't place it here.
                    event.setCanceled(true);
                }
            }

            if (GlobalConfig.debug) {
                event.getEntityPlayer().func_145747_a(new TextComponentTranslation("FillBucketEvent: %s,%s,%s,%s", event.getTarget().func_178782_a(), event.getTarget().field_72313_a, event.getEmptyBucket() != null ? event.getEmptyBucket().func_82833_r() : null, event.getFilledBucket() != null ? event.getFilledBucket().func_82833_r() : null));
                BWMod.getLog().info("FillBucketEvent: {}, {}, {}", event.getTarget(), event.getEmptyBucket(), event.getFilledBucket());
            }

        }
    }

}
