package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Sets;
import net.minecraft.block.*;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;

/**
 * Created by primetoxinz on 5/21/17.
 */
public class HCSeeds extends Feature {
    private static final Random RANDOM = new Random();
    public static Set<ItemStack> SEED_BLACKLIST = Sets.newHashSet(new ItemStack(Items.field_151014_N));
    public static Set<IBlockState> BLOCKS_TO_STOP = Sets.newHashSet();
    private static boolean stopZombieCropLoot;
    private static Predicate<IBlockState> STOP_SEEDS = state -> {
        Block block = state.func_177230_c();
        return BLOCKS_TO_STOP.contains(state) || block instanceof BlockTallGrass || (block instanceof BlockDoublePlant && (state.func_177229_b(BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS || state.func_177229_b(BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.FERN));
    };

    @Override
    public String getFeatureDescription() {
        return "Requires Tilling the ground with a hoe to get seeds.";
    }

    @Override
    public void setupConfig() {
        stopZombieCropLoot = loadPropBool("Stop Zombie Crop Loot", "Stops Zombies from dropping potatoes or carrots", true);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (STOP_SEEDS.test(event.getState()))
            event.getDrops().clear();
    }

    public NonNullList<ItemStack> getDrops(boolean isGrass, int fortune) {
        if (RANDOM.nextInt(8) != 0) return NonNullList.func_191196_a();
        ItemStack seed = net.minecraftforge.common.ForgeHooks.getGrassSeed(RANDOM, 0);
        if (SEED_BLACKLIST.stream().anyMatch(s -> InvUtils.matches(s, seed)) || seed.func_190926_b() || (!isGrass && seed.func_77973_b().equals(Item.func_150898_a(BWMBlocks.HEMP))))
            return NonNullList.func_191196_a();
        else
            return NonNullList.func_191197_a(1, seed);
    }

    @SubscribeEvent
    public void onHoe(UseHoeEvent e) {
        if (e.getResult() == Event.Result.DENY)
            return;
        World world = e.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = e.getPos();
            if (world.func_175623_d(pos.func_177984_a())) {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockGrass || state.func_177230_c() instanceof BlockDirt) {
                    InvUtils.ejectStackWithOffset(world, pos.func_177984_a(), getDrops(state.func_177230_c() instanceof BlockGrass, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent e) {
        if (!stopZombieCropLoot || !(e.getEntityLiving() instanceof EntityZombie))
            return;
        Iterator<EntityItem> iter = e.getDrops().iterator();
        EntityItem item;
        while (iter.hasNext()) {
            item = iter.next();
            ItemStack stack = item.func_92059_d();
            if (BWOreDictionary.hasPrefix(stack, "crop"))
                iter.remove();
        }

    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}
