package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDirtSlab;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Maps;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashMap;
import java.util.UUID;

public class HCMovement extends Feature {
    public final static UUID HCMOVEMENT_SPEED_UUID = UUID.fromString("aece6a05-d163-4871-aaf3-ebab43b0fcfa");

    public static final HashMap<Material, Float> MATERIAL_MOVEMENT = Maps.newHashMap();
    public static final HashMap<IBlockState, Float> BLOCK_OVERRIDE_MOVEMENT = Maps.newHashMap();
    public static final float DEFAULT_SPEED = 0.75f;
    public static final float FAST = 1.2f;
    public static boolean dirtpathQuality;

    @Override
    public void setupConfig() {
        dirtpathQuality = loadPropBool("Dirt Paths Require Quality Shovel", "Dirt Paths require a shovel greater than stone to be created", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Change walking speed depending on the block";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MATERIAL_MOVEMENT.put(Material.field_151576_e, FAST);
        MATERIAL_MOVEMENT.put(Material.field_151575_d, FAST);
        MATERIAL_MOVEMENT.put(Material.field_151573_f, FAST);
        MATERIAL_MOVEMENT.put(Material.field_151580_n, FAST);
        MATERIAL_MOVEMENT.put(Material.field_151593_r, FAST);
        MATERIAL_MOVEMENT.put(Material.field_151594_q, FAST);

        MATERIAL_MOVEMENT.put(Material.field_151577_b, 1.0f);
        MATERIAL_MOVEMENT.put(Material.field_151592_s, 1.0f);
        MATERIAL_MOVEMENT.put(Material.field_151578_c, 1.0f);
        MATERIAL_MOVEMENT.put(Material.field_151571_B, 1.0f);

        MATERIAL_MOVEMENT.put(Material.field_151595_p, 0.75f);
        MATERIAL_MOVEMENT.put(Material.field_151597_y, 0.75f);
        MATERIAL_MOVEMENT.put(Material.field_151584_j, 0.70f);
        MATERIAL_MOVEMENT.put(Material.field_151585_k, 0.70f);
        MATERIAL_MOVEMENT.put(Material.field_151582_l, 0.70f);

        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_150425_aM.func_176223_P(), 0.70f);
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_150351_n.func_176223_P(), FAST);
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.field_185774_da.func_176223_P(), FAST);
        BLOCK_OVERRIDE_MOVEMENT.put(BWMBlocks.DIRT_SLAB.func_176223_P().func_177226_a(BlockDirtSlab.VARIANT, BlockDirtSlab.DirtSlabType.PATH), FAST);
    }

    public static HashMap<UUID, Float> PREVIOUS_SPEED = Maps.newHashMap();

    @SubscribeEvent
    public void onWalk(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            float speed = 0;
            if (player.field_70122_E) {
                BlockPos blockpos = new BlockPos(MathHelper.func_76128_c(player.field_70165_t), MathHelper.func_76128_c(player.field_70163_u - 0.2D), MathHelper.func_76128_c(player.field_70161_v));
                IBlockState state = player.field_70170_p.func_180495_p(blockpos);

                if (BLOCK_OVERRIDE_MOVEMENT.containsKey(state)) {
                    speed = BLOCK_OVERRIDE_MOVEMENT.get(state);
                } else {
                    speed = MATERIAL_MOVEMENT.getOrDefault(state.func_185904_a(), DEFAULT_SPEED);
                }
                if (!player.field_70170_p.func_180495_p(player.func_180425_c()).func_185904_a().func_76220_a()) {
                    state = player.field_70170_p.func_180495_p(player.func_180425_c());
                    if (BLOCK_OVERRIDE_MOVEMENT.containsKey(state)) {
                        speed = BLOCK_OVERRIDE_MOVEMENT.get(state);
                    } else if (MATERIAL_MOVEMENT.containsKey(state.func_185904_a())) {
                        speed *= MATERIAL_MOVEMENT.get(state.func_185904_a());
                    }
                }
                PREVIOUS_SPEED.put(player.func_146103_bH().getId(), speed);
            }
            if (speed == 0)
                speed = PREVIOUS_SPEED.getOrDefault(player.func_146103_bH().getId(), DEFAULT_SPEED);
            PlayerHelper.changeSpeed(player, "HCMovement", speed, HCMOVEMENT_SPEED_UUID);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }


    //Should cancel out the FOV change from HCMovement entirely
    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        EntityPlayer player = event.getEntity();
        float f = 1.0F;

        if (player.field_71075_bZ.field_75100_b) {
            f *= 1.1F;
        }

        IAttributeInstance iattributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);

        double value = iattributeinstance.func_111126_e();
        AttributeModifier mod = iattributeinstance.func_111127_a(HCMovement.HCMOVEMENT_SPEED_UUID);
        if (mod != null)
            value /= (1 + mod.func_111164_d());
        f = (float) ((double) f * ((value / (double) player.field_71075_bZ.func_75094_b() + 1.0D) / 2.0D));

        if (player.field_71075_bZ.func_75094_b() == 0.0F || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0F;
        }
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() == Items.field_151031_f) {
            int i = player.func_184612_cw();
            float f1 = (float) i / 20.0F;

            if (f1 > 1.0F) {
                f1 = 1.0F;
            } else {
                f1 = f1 * f1;
            }

            f *= 1.0F - f1 * 0.15F;
        }

        event.setNewfov(f);
    }
}
