package betterwithmods.module.hardcore.needs;

import betterwithmods.BWMod;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.penalties.GloomPenalties;
import betterwithmods.common.penalties.GloomPenalty;
import betterwithmods.common.penalties.attribute.BWMAttributes;
import betterwithmods.module.Feature;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessageGloom;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Set;

/**
 * Created by primetoxinz on 5/13/17.
 */
public class HCGloom extends Feature {
    private static final List<SoundEvent> sounds = Lists.newArrayList(SoundEvents.field_187754_de, SoundEvents.field_187534_aX, SoundEvents.field_187532_aV, SoundEvents.field_187793_eY, SoundEvents.field_187861_gG);
    @CapabilityInject(Gloom.class)
    public static Capability<Gloom> GLOOM_CAPABILITY;
    public static GloomPenalties PENALTIES;
    private static Set<Integer> dimensionWhitelist;
    private static Ingredient gloomOverrideItems;
    private static ResourceLocation PLAYER_GLOOM = new ResourceLocation(BWMod.MODID, "gloom");

    public static int getGloomTime(EntityPlayer player) {
        Gloom gloom = getGloom(player);
        if (gloom != null)
            return gloom.getGloom();
        return 0;
    }

    public static void incrementGloomTime(EntityPlayerMP player) {
        int time = getGloomTime(player);
        setGloomTick(player, time + 1);
    }

    public static void setGloomTick(EntityPlayerMP player, int value) {
        Gloom gloom = getGloom(player);
        if (gloom != null) {
            gloom.setGloom(value);
            BWNetwork.INSTANCE.sendTo(new MessageGloom(player.func_110124_au().toString(), value), player);
        }
    }

    public static Gloom getGloom(Entity entity) {
        if (entity.hasCapability(GLOOM_CAPABILITY, null)) {
            return entity.getCapability(GLOOM_CAPABILITY, null);
        }
        return null;
    }

    @Override
    public void setupConfig() {
        dimensionWhitelist = Sets.newHashSet(ArrayUtils.toObject(loadPropIntList("Gloom Dimension Whitelist", "Gloom is only available in these dimensions", new int[]{0})));
        BWRegistry.PENALTY_HANDLERS.add(PENALTIES = new GloomPenalties());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(Gloom.class, new CapabilityGloom(), Gloom::new);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        gloomOverrideItems = StackIngredient.fromStacks(loadItemStackArray("Gloom Override Items", "Items in this list will override the gloom effect while held in your hand, this allows support for Dynamic Lightning and similar. Add one item per line  (ex minecraft:torch:0)", new ItemStack[0]));
    }

    @SubscribeEvent
    public void clone(net.minecraftforge.event.entity.player.PlayerEvent.Clone event) {
        Gloom o = getGloom(event.getOriginal());
        Gloom n = getGloom(event.getEntityPlayer());
        if (o != null && n != null) {
            n.deserializeNBT(o.serializeNBT());
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !event.getCapabilities().containsKey(PLAYER_GLOOM)) {
            event.addCapability(PLAYER_GLOOM, new Gloom());
        }
    }


    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        if (e.player instanceof EntityPlayerMP)
            setGloomTick((EntityPlayerMP) e.player, 0);
    }

    @SubscribeEvent
    public void inDarkness(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        World world = player.func_130014_f_();

        if (!PlayerHelper.isSurvival(player) || !dimensionWhitelist.contains(world.field_73011_w.getDimension()))
            return;

        if (e.player instanceof EntityPlayerMP) {
            EntityPlayerMP playermp = (EntityPlayerMP) player;
            if (!world.field_72995_K) {
                int light = world.func_175699_k(playermp.func_180425_c().func_177984_a());
                int tick = getGloomTime(playermp);
                if (PlayerHelper.isHolding(playermp, gloomOverrideItems))
                    light = 15;
                if (player.func_70644_a(MobEffects.field_76439_r))
                    light = 15;
                if (light <= 0) {
                    incrementGloomTime(playermp);
                } else if (tick != 0) {
                    setGloomTick(playermp, 0);
                }
            }

            if (world.func_82737_E() % 40 == 0) {
                if (world.field_73012_v.nextInt(2) == 0) {
                    if (BWRegistry.PENALTY_HANDLERS.attackedByGrue(player)) {
                        player.func_70097_a(BWDamageSource.gloom, 2);
                    }
                }
            }
        }

        //Client Side
        //Random sounds
        if (world.field_72995_K) {
            float spooked = BWRegistry.PENALTY_HANDLERS.getSpooked(player);
            GloomPenalty most = PENALTIES.getMostSevere();

            if (world.field_73012_v.nextDouble() <= spooked) {
                player.func_184185_a(SoundEvents.field_187674_a, 0.7F, 0.8F + world.field_73012_v.nextFloat() * 0.2F);

                if (most != null && (spooked >= (most.getFloat(BWMAttributes.SPOOKED).getValue()))) {
                    if (world.field_73012_v.nextInt(5) == 0)
                        player.func_184185_a(sounds.get(world.field_73012_v.nextInt(sounds.size())), 0.7F, 0.8F + world.field_73012_v.nextFloat() * 0.2F);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 1, false, false));
                }
            }
        }


    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        float spooked = BWRegistry.PENALTY_HANDLERS.getSpooked(event.getEntity());
        GloomPenalty most = PENALTIES.getMostSevere();
        if (most != null && (spooked >= (most.getFloat(BWMAttributes.SPOOKED).getValue()))) {
            float change = -(getGloomTime(event.getEntity()) / 100000f);
            event.setNewfov(event.getFov() + change);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Be afraid of the dark...";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class CapabilityGloom implements Capability.IStorage<Gloom> {

        @Nullable
        @Override
        public NBTBase writeNBT(Capability<Gloom> capability, Gloom instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        @Override
        public void readNBT(Capability<Gloom> capability, Gloom instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound) nbt);
        }
    }

    public static class Gloom implements ICapabilitySerializable<NBTTagCompound> {

        private int gloom;

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == GLOOM_CAPABILITY;
        }

        @Nullable
        @Override
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (hasCapability(capability, facing))
                return GLOOM_CAPABILITY.cast(this);
            return null;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("gloom", gloom);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("gloom")) {
                gloom = nbt.func_74762_e("gloom");
            }
        }

        public int getGloom() {
            return gloom;
        }

        public void setGloom(int gloom) {
            this.gloom = gloom;
        }
    }


}
