package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.penalties.ArmorPenalties;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.util.item.StackMap;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

/**
 * Created by primetoxinz on 5/10/17.
 */
public class HCArmor extends Feature {

    public static ArmorPenalties penalties;

    public static final StackMap<Integer> weights = new StackMap<>(0);

    public static boolean shieldRebalance;

    public static float getWeight(ItemStack stack) {
        if (!ModuleLoader.isFeatureEnabled(HCArmor.class))
            return 0;
        return weights.get(stack);
    }



    public static void initWeights() {

        weights.put(Items.field_151020_U, OreDictionary.WILDCARD_VALUE, 3);
        weights.put(Items.field_151023_V, OreDictionary.WILDCARD_VALUE, 4);
        weights.put(Items.field_151022_W, OreDictionary.WILDCARD_VALUE, 4);
        weights.put(Items.field_151029_X, OreDictionary.WILDCARD_VALUE, 2);

        weights.put(Items.field_151028_Y, OreDictionary.WILDCARD_VALUE, 5);
        weights.put(Items.field_151030_Z, OreDictionary.WILDCARD_VALUE, 8);
        weights.put(Items.field_151165_aa, OreDictionary.WILDCARD_VALUE, 7);
        weights.put(Items.field_151167_ab, OreDictionary.WILDCARD_VALUE, 4);

        weights.put(Items.field_151161_ac, OreDictionary.WILDCARD_VALUE, 5);
        weights.put(Items.field_151163_ad, OreDictionary.WILDCARD_VALUE, 8);
        weights.put(Items.field_151173_ae, OreDictionary.WILDCARD_VALUE, 7);
        weights.put(Items.field_151175_af, OreDictionary.WILDCARD_VALUE, 4);

        weights.put(BWMItems.STEEL_HELMET, OreDictionary.WILDCARD_VALUE, 5);
        weights.put(BWMItems.STEEL_CHEST, OreDictionary.WILDCARD_VALUE, 8);
        weights.put(BWMItems.STEEL_PANTS, OreDictionary.WILDCARD_VALUE, 7);
        weights.put(BWMItems.STEEL_BOOTS, OreDictionary.WILDCARD_VALUE, 4);

        weights.put(Items.field_151169_ag, OreDictionary.WILDCARD_VALUE, 5);
        weights.put(Items.field_151171_ah, OreDictionary.WILDCARD_VALUE, 8);
        weights.put(Items.field_151149_ai, OreDictionary.WILDCARD_VALUE, 7);
        weights.put(Items.field_151151_aj, OreDictionary.WILDCARD_VALUE, 4);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (shieldRebalance) {
            addHardcoreRecipe(new ShapedOreRecipe(null, new ItemStack(Items.field_185159_cQ),
                    "SWS", "WIW", " W ", 'S', "strapLeather", 'W', "sidingWood", 'I', "ingotIron"
            ).setRegistryName("minecraft:shield"));
        }
        initWeights();
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void setupConfig() {
        BWRegistry.PENALTY_HANDLERS.add(penalties = new ArmorPenalties());
        shieldRebalance = loadPropBool("Shield Rebalance", "Experimental recipes for rebalacing shields", false);

    }

    @Override
    public String getFeatureDescription() {
        return "Gives Armor weight values that effect movement. Changes Entity armor spawning: Zombies only spawn with Iron armor, Skeletons never wear armor.";
    }
}
