package betterwithmods.module.hardcore.creatures;

import betterwithmods.module.Feature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSquid extends Feature {


    @Override
    public String getFeatureDescription() {
        return "Fear the squid...";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SuppressWarnings("unchecked")
    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntitySquid) {
            EntitySquid squid = (EntitySquid) event.getEntity();
//            squid.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(64d);
            squid.func_189654_d(true);

            squid.field_70714_bg.field_75782_a.clear();
            squid.field_70714_bg.func_75776_a(2, new AIAttackRiding(squid));
            squid.field_70714_bg.func_75776_a(2, new AIMount(squid, 2));
            squid.field_70714_bg.func_75776_a(3, new AIGrab(squid, 2, 10));
            //wander 7
            squid.field_70714_bg.func_75776_a(8, new EntityAIWatchClosest(squid, EntityPlayer.class, 100f));
            squid.field_70715_bh.func_75776_a(2, new EntityAIFindEntityNearest(squid, EntityPlayer.class));
//            squid.targetTasks.taskEntries.clear();
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntitySquid) {
            EntitySquid squid = (EntitySquid) event.getEntityLiving();
            squid.func_70050_g(300);
            if (squid.func_184218_aH() && squid.func_184187_bx() instanceof EntityLivingBase) {
                //Keep vertical
                float f1 = MathHelper.func_76133_a(squid.field_70159_w * squid.field_70159_w + squid.field_70179_y * squid.field_70179_y);
                squid.field_70861_d += (-((float) MathHelper.func_181159_b((double) f1, squid.field_70181_x)) * (180F / (float) Math.PI) - squid.field_70861_d) * 0.5F;
            }
        }
    }

    @SubscribeEvent
    public void onClicked(PlayerInteractEvent.EntityInteractSpecific event) {

    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntitySquid && event.isDismounting() && event.getEntityMounting().func_70089_S()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }
}
