package betterwithmods.module.hardcore.creatures;

import betterwithmods.bwl.event.EntitySetEquipmentEvent;
import betterwithmods.module.CompatFeature;
import com.google.common.collect.Maps;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.Map;

public class HCMobEquipment extends CompatFeature {
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public static final ItemStack[] IRON_ARMOR = new ItemStack[]{new ItemStack(Items.field_151028_Y), new ItemStack(Items.field_151030_Z), new ItemStack(Items.field_151165_aa), new ItemStack(Items.field_151167_ab)};
    public static final ItemStack[] GOLD_ARMOR = new ItemStack[]{new ItemStack(Items.field_151169_ag), new ItemStack(Items.field_151171_ah), new ItemStack(Items.field_151149_ai), new ItemStack(Items.field_151151_aj)};


    private static Map<ResourceLocation, Equipment> entityMap = Maps.newHashMap();

    public HCMobEquipment() {
        super("betterwithlib");
        enabledByDefault = false;
    }

    private static void pigman(EntityLivingBase entity ) {
        if (entity.func_70681_au().nextFloat() < 0.05F) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        }
        armor(entity, GOLD_ARMOR);
    }


    private static void skeleton(EntityLivingBase entity) {
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151031_f));
    }

    private static void zombie(EntityLivingBase entity ) {
        armor(entity, IRON_ARMOR);
        if (entity.func_70681_au().nextFloat() < 0.05F) {
            int i = entity.func_70681_au().nextInt(3);
            if (i == 0) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l).func_77946_l());
            } else {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a).func_77946_l());
            }
        }
    }

    private static void armor(EntityLivingBase entity, ItemStack[] armor) {
        if (entity.func_70681_au().nextFloat() < 0.018) {
            boolean flag = true;
            for (int s = 0; s < ARMOR_SLOTS.length; s++) {
                EntityEquipmentSlot slot = ARMOR_SLOTS[s];
                ItemStack current = entity.func_184582_a(slot);
                if (current.func_190926_b()) {
                    if (!flag && entity.func_70681_au().nextFloat() < 0.1) {
                        continue;
                    }
                    flag = false;
                    entity.func_184201_a(slot, armor[s].func_77946_l());
                }
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        addEquipmentOverride(new ResourceLocation("minecraft:zombie"), HCMobEquipment::zombie);
        addEquipmentOverride(new ResourceLocation("minecraft:husk"), HCMobEquipment::zombie);
        addEquipmentOverride(new ResourceLocation("minecraft:skeleton"), HCMobEquipment::skeleton);
        addEquipmentOverride(new ResourceLocation("minecraft:zombie_pigman"), HCMobEquipment::pigman);
    }

    public void addEquipmentOverride(ResourceLocation mob, Equipment equipment) {
        if(loadPropBool("Override Equipment for " + mob.toString(), "", true)) {
            entityMap.put(mob,equipment);
        }
    }

    @SubscribeEvent
    public void onSetEquipment(EntitySetEquipmentEvent event) {
        EntityLivingBase entity = (EntityLivingBase) event.getEntity();
        ResourceLocation key = EntityList.func_191301_a(entity);

        Equipment equipment = entityMap.get(key);
        if (equipment != null) {
            event.setCanceled(true);
            equipment.equip(entity);
        }
    }
    
    @Override
    public String getFeatureDescription() {
        return "Change the equipment that mobs spawn with";
    }


    @FunctionalInterface
    private interface Equipment {
        void equip(EntityLivingBase entity);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}
