package betterwithmods.module.hardcore.creatures;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

public class EntityTentacle extends Entity implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.<Integer>func_187226_a(net.minecraft.entity.projectile.EntityFishHook.class, DataSerializers.field_187192_b);
    private boolean inGround;
    private int ticksInGround;
    private EntityLivingBase angler;
    private int ticksInAir;
    public Entity caughtEntity;
    private State currentState = State.FLYING;

    public EntityTentacle(World world) {
        this(world, null);
    }


    public EntityTentacle(World worldIn, EntityLivingBase angler) {
        super(worldIn);
        this.func_70105_a(0.25F, 0.25F);
        this.field_70158_ak = true;
        this.angler = angler;
        shoot();
    }

    private void shoot() {
        if (this.angler == null)
            return;
        float f = this.angler.field_70127_C + (this.angler.field_70125_A - this.angler.field_70127_C);
        float f1 = this.angler.field_70126_B + (this.angler.field_70177_z - this.angler.field_70126_B);
        float f2 = MathHelper.func_76134_b(-f1 * 0.017453292F - (float) Math.PI);
        float f3 = MathHelper.func_76126_a(-f1 * 0.017453292F - (float) Math.PI);
        float f4 = -MathHelper.func_76134_b(-f * 0.017453292F);
        float f5 = MathHelper.func_76126_a(-f * 0.017453292F);
        double anglerX = this.angler.field_70169_q + (this.angler.field_70165_t - this.angler.field_70169_q);
        double anglerY = this.angler.field_70163_u + (this.angler.field_70163_u - this.angler.field_70167_r) + (double) this.angler.func_70047_e() * 2;
        double anglerZ = this.angler.field_70166_s + (this.angler.field_70161_v - this.angler.field_70166_s);

        this.func_70012_b(anglerX, anglerY, anglerZ, f1, f);
        this.field_70159_w = (double) (-f3);
        this.field_70181_x = (double) MathHelper.func_76131_a(-(f5 / f4), -5.0F, 5.0F);
        this.field_70179_y = (double) (-f2);
        float f6 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        this.field_70159_w *= 0.6D / (double) f6 + 0.5D + this.field_70146_Z.nextGaussian() * 0.0045D;
        this.field_70181_x *= 0.6D / (double) f6 + 0.5D + this.field_70146_Z.nextGaussian() * 0.0045D;
        this.field_70179_y *= 0.6D / (double) f6 + 0.5D + this.field_70146_Z.nextGaussian() * 0.0045D;
        float f7 = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = (float) (MathHelper.func_181159_b(this.field_70159_w, this.field_70179_y) * (180D / Math.PI));
        this.field_70125_A = (float) (MathHelper.func_181159_b(this.field_70181_x, (double) f7) * (180D / Math.PI));
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, 0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    /**
     * Checks if the entity is in range to render.
     */
    @SideOnly(Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0D;
    }

    /**
     * Set the position and rotation values directly without any clamping.
     */
    @SideOnly(Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    /**
     * Called to update the entity's position/logic.
     */
    public void func_70071_h_() {
        super.func_70071_h_();

        if (this.angler == null || !angler.func_70089_S()) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;

                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }

            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.field_70159_w = 0.0D;
                    this.field_70181_x = 0.0D;
                    this.field_70179_y = 0.0D;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }

                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }

                if (!this.inGround && !this.field_70122_E && !this.field_70123_F) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0D;
                    this.field_70181_x = 0.0D;
                    this.field_70179_y = 0.0D;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.field_70128_L) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.caughtEntity.field_70165_t;
                            double d2 = (double) this.caughtEntity.field_70131_O;
                            this.field_70163_u = this.caughtEntity.func_174813_aQ().field_72338_b + d2 * 0.8D;
                            this.field_70161_v = this.caughtEntity.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }

                    return;
                }
            }


            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            this.field_70159_w *= 0.92D;
            this.field_70181_x *= 0.92D;
            this.field_70179_y *= 0.92D;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private boolean shouldStopFishing() {
        return !this.angler.func_70089_S();
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = (float) (MathHelper.func_181159_b(this.field_70159_w, this.field_70179_y) * (180D / Math.PI));

        for (this.field_70125_A = (float) (MathHelper.func_181159_b(this.field_70181_x, (double) f) * (180D / Math.PI)); this.field_70125_A - this.field_70127_C < -180.0F; this.field_70127_C -= 360.0F) {
        }

        while (this.field_70125_A - this.field_70127_C >= 180.0F) {
            this.field_70127_C += 360.0F;
        }

        while (this.field_70177_z - this.field_70126_B < -180.0F) {
            this.field_70126_B -= 360.0F;
        }

        while (this.field_70177_z - this.field_70126_B >= 180.0F) {
            this.field_70126_B += 360.0F;
        }

        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2F;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2F;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);

        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }

        Entity entity = null;
        List<Entity> list = this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0D));
        double d0 = 0.0D;

        for (Entity entity1 : list) {
            if (this.canBeHooked(entity1) && (entity1 != this.angler || this.ticksInAir >= 5)) {
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.30000001192092896D);
                RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);

                if (raytraceresult1 != null) {
                    double d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f);

                    if (d1 < d0 || d0 == 0.0D) {
                        entity = entity1;
                        d0 = d1;
                    }
                }
            }
        }

        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }

        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = raytraceresult.field_72308_g;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, this.caughtEntity.func_145782_y() + 1);
    }

    protected boolean canBeHooked(Entity entity) {
        return entity.func_70067_L();
    }

    /**
     * (abstract) Protected helper method to write subclass entity data to NBT.
     */
    public void func_70014_b(NBTTagCompound compound) {
    }

    /**
     * (abstract) Protected helper method to read subclass entity data from NBT.
     */
    public void func_70037_a(NBTTagCompound compound) {
    }

    public int handleHookRetraction() {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.field_70170_p.func_72960_a(this, (byte) 31);
            }
            this.func_70106_y();
        }
        return 0;
    }

    /**
     * Handler for {@link World#setEntityState}
     */
    @SideOnly(Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof EntityPlayer && ((EntityPlayer) this.caughtEntity).func_175144_cb()) {
            this.bringInHookedEntity();
        }

        super.func_70103_a(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null && this.caughtEntity != null) {
            double d0 = this.angler.field_70165_t - this.field_70165_t;
            double d1 = this.angler.field_70163_u - this.field_70163_u;
            double d2 = this.angler.field_70161_v - this.field_70161_v;
            double d3 = 0.5D;
            this.caughtEntity.field_70159_w += d0 * d3;
            this.caughtEntity.field_70181_x += d1 * d3;
            this.caughtEntity.field_70179_y += d2 * d3;
        }
    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    protected boolean func_70041_e_() {
        return false;
    }

    /**
     * Will get destroyed next tick.
     */
    public void func_70106_y() {
        super.func_70106_y();
    }

    public EntityLivingBase getAngler() {
        return angler;
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        if (angler != null)
            buffer.writeInt(angler.func_145782_y());
        else
            buffer.writeInt(0);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        angler = (EntityLivingBase) Minecraft.func_71410_x().field_71441_e.func_73045_a(additionalData.readInt());
    }

    enum State {
        FLYING,
        HOOKED_IN_ENTITY,
    }
}
