package betterwithmods.module.hardcore.creatures;

import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.items.tools.ItemSoulforgeArmor;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.SoundCategory;

public class AIAttackRiding extends EntityAIBase {

    public EntityLivingBase rider;

    public AIAttackRiding(EntityLivingBase rider) {
        this.rider = rider;
    }

    @Override
    public boolean func_75250_a() {
        return rider.func_184218_aH() && rider.func_184187_bx() instanceof EntityLivingBase;
    }

    @Override
    public boolean func_75253_b() {
        return rider.func_184187_bx() != null && rider.func_184187_bx().func_70089_S();
    }

    @Override
    public void func_75246_d() {
        EntityLivingBase mount = (EntityLivingBase) rider.func_184187_bx();
        //Attack if not wearing a SFS helmet
        if (mount == null)
            return;
        if(mount instanceof EntityPlayer) {
            if (!PlayerHelper.hasPart(mount, EntityEquipmentSlot.HEAD, ItemSoulforgeArmor.class)) {
                if (mount.field_70170_p.field_73012_v.nextInt(5) == 0)
                    mount.field_70170_p.func_184133_a(null, mount.func_180425_c(), SoundEvents.field_187833_fS, SoundCategory.HOSTILE, 0.5f, 1);
                mount.func_70097_a(BWDamageSource.squid, 0);
//                ((EntityPlayer) mount).addExhaustion(1f);
            }
        } else {
            mount.func_70097_a(BWDamageSource.squid, 0);
        }

    }
}
