package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.entity.EntityFallingGourd;
import betterwithmods.module.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class HCMelon extends Feature{
    @Override
    public String getFeatureDescription() {
        return "Makes Melons have gravity, makes for cool automation abilities";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c().equals(Blocks.field_150440_ba)) {
            event.getDrops().removeIf(x -> x.func_77973_b().equals(Items.field_151127_ba));
            event.getDrops().add(new ItemStack(Blocks.field_150440_ba, 1));
        }
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        makeGourdFall(world, event.getPos());
        makeGourdFall(world, event.getPos().func_177984_a());
    }

    private void makeGourdFall(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockMelon || block instanceof BlockPumpkin) {
            BlockPos bottompos = pos.func_177977_b();
            IBlockState bottomstate = world.func_180495_p(bottompos);
            if (world.func_175623_d(bottompos) || BlockFalling.func_185759_i(bottomstate)) {
                if (!world.field_72995_K && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                    EntityFallingGourd entitygourd = new EntityFallingGourd(world, (double) pos.func_177958_n() + 0.5, pos.func_177956_o(), (double) pos.func_177952_p() + 0.5, blockstate);
                    if (block instanceof BlockPumpkin) entitygourd.setSeedStack(new ItemStack(Items.field_151080_bb));
                    else entitygourd.setSeedStack(new ItemStack(Items.field_151081_bc));
                    world.func_72838_d(entitygourd);
                }
            }
        }
    }
    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}
