package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockFurnace;
import betterwithmods.module.Feature;
import com.google.common.collect.Maps;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;

public class HCFurnace extends Feature {
    public static final Block FURNACE = new BlockFurnace(false).setRegistryName("minecraft:furnace");
    public static final Block LIT_FURNACE = new BlockFurnace(true).setRegistryName("minecraft:lit_furnace");
    public static boolean CONSUME_FUEL_WHEN_IDLE, TOOLTIP;
    public static int DEFAULT_FURNACE_TIMING = 200;
    public static HashMap<Ingredient, Integer> FURNACE_TIMINGS = Maps.newHashMap();
    public static HashMap<Ingredient, Integer> FUEL_TIMINGS = Maps.newHashMap();

    public HCFurnace() {
        enabledByDefault = false;
    }

    public static OptionalInt getCookingTime(ItemStack stack) {
        return FURNACE_TIMINGS.entrySet().stream().filter(e -> e.getKey().apply(stack)).mapToInt(Map.Entry::getValue).findAny();
    }

    @Override
    public void setupConfig() {
        CONSUME_FUEL_WHEN_IDLE = loadPropBool("Consume Fuel When Idle", "Furnaces will consume fuel even if no smeltable items are present.", true);
        DEFAULT_FURNACE_TIMING = loadPropInt("Default Furnace Timing", "Default number of ticks for an item to smelt in the furnace (vanilla is 200)", "", 200, 1, Integer.MAX_VALUE);
        TOOLTIP = loadPropBool("Tooltip for modified cooking time", "Shows a tooltip for items with modified cooking time", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Overrides the vanilla furnace to allow for some changes: Allows varying item cook times, changes fuel values and a tweak to make the furnace visually show whether it has content";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMBlocks.registerBlock(FURNACE);
        BWMBlocks.registerBlock(LIT_FURNACE, null);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {


        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150482_ag));
        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150365_q));
        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150412_bA));
        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150450_ax));
        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150369_x));
        BWMRecipes.removeFurnaceRecipe(new ItemStack(Blocks.field_150371_ca));

        //Remove Furnace Recyclcing

        BWMRecipes.removeFurnaceRecipe(Items.field_151020_U);
        BWMRecipes.removeFurnaceRecipe(Items.field_151023_V);
        BWMRecipes.removeFurnaceRecipe(Items.field_151022_W);
        BWMRecipes.removeFurnaceRecipe(Items.field_151029_X);
        BWMRecipes.removeFurnaceRecipe(Items.field_151035_b);
        BWMRecipes.removeFurnaceRecipe(Items.field_151037_a);
        BWMRecipes.removeFurnaceRecipe(Items.field_151036_c);
        BWMRecipes.removeFurnaceRecipe(Items.field_151019_K);
        BWMRecipes.removeFurnaceRecipe(Items.field_151040_l);
        BWMRecipes.removeFurnaceRecipe(Items.field_151028_Y);
        BWMRecipes.removeFurnaceRecipe(Items.field_151030_Z);
        BWMRecipes.removeFurnaceRecipe(Items.field_151165_aa);
        BWMRecipes.removeFurnaceRecipe(Items.field_151167_ab);
        BWMRecipes.removeFurnaceRecipe(Items.field_151138_bX);
        BWMRecipes.removeFurnaceRecipe(Items.field_151005_D);
        BWMRecipes.removeFurnaceRecipe(Items.field_151011_C);
        BWMRecipes.removeFurnaceRecipe(Items.field_151006_E);
        BWMRecipes.removeFurnaceRecipe(Items.field_151013_M);
        BWMRecipes.removeFurnaceRecipe(Items.field_151010_B);
        BWMRecipes.removeFurnaceRecipe(Items.field_151169_ag);
        BWMRecipes.removeFurnaceRecipe(Items.field_151171_ah);
        BWMRecipes.removeFurnaceRecipe(Items.field_151149_ai);
        BWMRecipes.removeFurnaceRecipe(Items.field_151151_aj);
        BWMRecipes.removeFurnaceRecipe(Items.field_151136_bY);

        FURNACE_TIMINGS = loadItemStackIntMap("Furnace Timing Recipes", "example recipes  minecraft:iron_ore=1000  or ore:oreIron=1000", new String[]{
                "ore:oreIron=3200",
                "ore:oreGold=3200",
                "ore:cobblestone=3200",
                "ore:sand=3200"
        });

        FUEL_TIMINGS = loadItemStackIntMap("Furnace Fuel Timing Overrides", "Overrides the fuel time for inputted items or oredict, see Furnace Timing for entry format", new String[]{
                "minecraft:boat=750",
                "minecraft:log:0=3200",
                "minecraft:log:1=2400",
                "minecraft:log:2=4200",
                "minecraft:log:3=1600",
                "minecraft:log2:0=3200",
                "minecraft:log2:1=1600",
                "minecraft:coal:0=3200",
                "minecraft:planks:0=900",
                "minecraft:planks:1=700",
                "minecraft:planks:2=1100",
                "minecraft:planks:3=500",
                "minecraft:planks:4=900",
                "minecraft:planks:5=700",
                "minecart:sapling=25"
        });
    }

    @SubscribeEvent
    @SideOnly(Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent event) {
        event.getMap().func_174942_a(new ResourceLocation("betterwithmods:blocks/furnace_full"));
    }

    @SubscribeEvent
    public void getFurnaceFuel(FurnaceFuelBurnTimeEvent event) {
        int speed = FUEL_TIMINGS.entrySet().stream().filter(e -> e.getKey().apply(event.getItemStack())).mapToInt(Map.Entry::getValue).findAny().orElse(-1);
        if (speed >= 0) {
            event.setBurnTime(speed);
        }
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if(!TOOLTIP)
            return;
        if (!FurnaceRecipes.func_77602_a().func_151395_a(event.getItemStack()).func_190926_b()) {
            event.getToolTip().add(I18n.func_74837_a("bwm.hcfurnace.cook_time.tooltip", HCFurnace.getCookingTime(event.getItemStack()).orElse(HCFurnace.DEFAULT_FURNACE_TIMING)));
        }
    }

}

