package betterwithmods.module.hardcore.crafting;

import betterwithmods.BWMod;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.entity.EntityHCFishHook;
import betterwithmods.common.registry.crafting.BaitingRecipe;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Random;

/**
 * Created by primetoxinz on 7/23/17.
 */
public class HCFishing extends Feature {
    public static boolean requireBait, restrictToOpenWater;
    public static int minimumWaterDepth;

    public static ResourceLocation HCFISHING_LOOT = LootTableList.func_186375_a(new ResourceLocation(BWMod.MODID, "gameplay/fishing"));

    private static final ResourceLocation BAITED_FISHING_ROD = new ResourceLocation(BWMod.MODID, "baited_fishing_rod");
    public static Ingredient BAIT = Ingredient.field_193370_a;

    @Override
    public void setupConfig() {
        requireBait = loadPropBool("Require Bait", "Change Fishing Rods to require being Baited with certain items to entice fish, they won't nibble without it!", true);
        restrictToOpenWater = loadPropBool("Restrict to Open Water", "Fishing on underground locations won't work, hook must be placed on a water block with line of sight to the sky.", true);
        minimumWaterDepth = loadPropInt("Minimum Water Depth", "If higher than 1, requires bodies of water to have a minimum depth for fishing to be successful.", 3);

    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(FishingBait.class, new CapabilityFishingRod(), FishingBait::new);
        BWMRecipes.removeRecipe(new ResourceLocation("fishing_rod"));

    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        BAIT = StackIngredient.fromStacks(loadItemStackArray("Bait", "Add items as valid fishing bait", new ItemStack[]{
                new ItemStack(Items.field_151070_bp),
                new ItemStack(BWMItems.CREEPER_OYSTER),
                new ItemStack(Items.field_151115_aP, 1, 2),
                new ItemStack(Items.field_151115_aP, 1, 3),
                new ItemStack(BWMItems.BAT_WING, 1),
                new ItemStack(BWMItems.COOKED_BAT_WING, 1),
                new ItemStack(Items.field_151078_bh)
        }));
        addHardcoreRecipe(new BaitingRecipe());
    }

    //Override loottables

    @SubscribeEvent(priority = EventPriority.HIGHEST)
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals(LootTableList.field_186387_al)) {
            LootTable table = event.getLootTableManager().func_186521_a(HCFISHING_LOOT);
            //FIXME this is a shitty hack to stop the overriding loottable from being frozen immediately and stopping other modded events from being able to apply their additions to to the fishing loottable
            ReflectionHelper.setPrivateValue(LootTable.class, table, false, "isFrozen");
            event.setTable(table);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Change Fishing Rods to require bait and a large enough water source exposed to the sky.";
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (event.getObject().func_77973_b() instanceof ItemFishingRod) {
            event.addCapability(BAITED_FISHING_ROD, new FishingBait());
        }
    }

    @SubscribeEvent
    public void onFished(ItemFishedEvent event) {
        BlockPos hookPos = getHookSurfacePos(event.getHookEntity());
        if (restrictToOpenWater) {
            if (event.getHookEntity().func_130014_f_().func_189649_b(hookPos.func_177958_n(), hookPos.func_177952_p()) > hookPos.func_177956_o() || !isAirBlock(event.getHookEntity().func_130014_f_(), hookPos)) {
                event.setCanceled(true);
                event.getEntityPlayer().func_145747_a(new TextComponentTranslation("bwm.message.needs_open_sky"));
                return;
            }
        }
        if (minimumWaterDepth > 1) {
            for (int i = 1; i <= minimumWaterDepth; i++) {
                if (!isWaterBlock(event.getHookEntity().func_130014_f_(), hookPos.func_177982_a(0, (i * -1), 0))) {
                    event.setCanceled(true);
                    event.getEntityPlayer().func_145747_a(new TextComponentTranslation("bwm.message.needs_deep_water"));
                    return;
                }
            }
        }
        if (requireBait) {
            ItemStack stack = getMostRelevantFishingRod(event.getEntityPlayer());
            if (isFishingRod(stack)) {
                FishingBait cap = stack.getCapability(FISHING_ROD_CAP, EnumFacing.UP);
                if (cap.hasBait()) {
                    cap.setBait(false);
                    NBTTagCompound tag = stack.func_77978_p();
                    if (tag != null && tag.func_74764_b("bait")) {
                        tag.func_74757_a("bait", false);
                    }
                }
            }
        }
    }

    private static ActionResult<ItemStack> throwLine(Item item, EntityPlayer player, EnumHand hand, World world, Random rand) {
        ItemStack itemstack = player.func_184586_b(hand);

        if (player.field_71104_cf != null) {
            int i = player.field_71104_cf.func_146034_e();
            itemstack.func_77972_a(i, player);
            player.func_184609_a(hand);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0F, 0.4F / (rand.nextFloat() * 0.4F + 0.8F));
        } else {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5F, 0.4F / (rand.nextFloat() * 0.4F + 0.8F));

            if (!world.field_72995_K) {
                EntityHCFishHook entityfishhook = new EntityHCFishHook(world, player);
                int j = EnchantmentHelper.func_191528_c(itemstack);

                if (j > 0) {
                    entityfishhook.func_191516_a(j);
                }

                int k = EnchantmentHelper.func_191529_b(itemstack);

                if (k > 0) {
                    entityfishhook.func_191517_b(k);
                }

                world.func_72838_d(entityfishhook);
            }

            player.func_184609_a(hand);
            player.func_71029_a(StatList.func_188057_b(item));
        }

        return new ActionResult<>(EnumActionResult.SUCCESS, itemstack);
    }

    @SubscribeEvent
    public void useFishingRod(PlayerInteractEvent.RightClickItem event) {
        if (requireBait) {
            if (isFishingRod(event.getItemStack())) {
                FishingBait cap = event.getItemStack().getCapability(FISHING_ROD_CAP, EnumFacing.UP);
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
                if (cap != null) {
                    if (cap.hasBait() || event.getEntityPlayer().func_184812_l_()) {
                        throwLine(event.getItemStack().func_77973_b(), event.getEntityPlayer(), event.getHand(), event.getWorld(), event.getWorld().field_73012_v).func_188397_a();
                    } else if (!event.getWorld().field_72995_K && (event.getHand() == EnumHand.MAIN_HAND || event.getHand() == EnumHand.OFF_HAND)) {
                        event.getEntityPlayer().func_145747_a(new TextComponentTranslation("bwm.message.needs_bait"));
                    }
                }
            }
        }
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (requireBait) {
            ItemStack stack = event.getItemStack();
            if (isFishingRod(stack)) {
                FishingBait cap = event.getItemStack().getCapability(FISHING_ROD_CAP, EnumFacing.UP);
                boolean bait = cap.hasBait();
                String tooltip = bait ? "Baited" : "Unbaited";
                if (!bait) {
                    NBTTagCompound tag = stack.func_77978_p();
                    if (tag != null && tag.func_74764_b("bait")) {
                        tooltip = tag.func_74767_n("bait") ? "Baited" : "Unbaited";
                    }
                }
                event.getToolTip().add(tooltip);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static boolean isFishingRod(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFishingRod && stack.hasCapability(FISHING_ROD_CAP, EnumFacing.UP);
    }

    public static ItemStack getMostRelevantFishingRod(EntityPlayer player) {
        ItemStack itemMain = player.func_184614_ca();
        if (isFishingRod(itemMain) && itemMain.getCapability(FISHING_ROD_CAP, EnumFacing.UP).hasBait()) {
            return itemMain;
        } else {
            return player.func_184592_cb();
        }
    }

    public static boolean isBaited(ItemStack stack, boolean baited) {
        return isFishingRod(stack) && stack.getCapability(FISHING_ROD_CAP, EnumFacing.UP).hasBait() == baited;
    }

    public static ItemStack setBaited(ItemStack rod, boolean baited) {
        if (rod.hasCapability(FISHING_ROD_CAP, EnumFacing.UP)) {
            FishingBait cap = rod.getCapability(FISHING_ROD_CAP, EnumFacing.UP);
            cap.setBait(baited);
        }
        if (rod.func_77978_p() == null) {
            rod.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = rod.func_77978_p();
        tag.func_74757_a("bait", baited);
        return new ItemStack(rod.serializeNBT());
    }

    public static BlockPos getHookSurfacePos(EntityFishHook hookEntity) {
        World world = hookEntity.func_130014_f_();
        BlockPos hookPos = hookEntity.func_180425_c();
        int heightOffset = 0;
        while (isWaterBlock(world, hookPos.func_177982_a(0, heightOffset, 0)) && (hookPos.func_177956_o() + heightOffset < 255)) {
            heightOffset++;
        }
        return hookPos.func_177982_a(0, heightOffset, 0);
    }

    public static boolean isWaterBlock(World world, BlockPos pos) {
        return (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos).func_177230_c() == Blocks.field_150358_i);
    }

    public static boolean isAirBlock(World world, BlockPos pos) {
        return (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a);
    }


    @SuppressWarnings("CanBeFinal")
    @CapabilityInject(FishingBait.class)
    public static Capability<FishingBait> FISHING_ROD_CAP = null;

    public static class CapabilityFishingRod implements Capability.IStorage<FishingBait> {

        @Nullable
        @Override
        public NBTBase writeNBT(Capability<FishingBait> capability, FishingBait instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        @Override
        public void readNBT(Capability<FishingBait> capability, FishingBait instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound) nbt);
        }
    }

    public static class FishingBait implements ICapabilitySerializable<NBTTagCompound> {
        private boolean bait;

        public FishingBait() {}

        public boolean hasBait() {
            return bait;
        }

        public void setBait(boolean bait) {
            this.bait = bait;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == FISHING_ROD_CAP;
        }

        @Nullable
        @Override
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == FISHING_ROD_CAP)
                return FISHING_ROD_CAP.cast(this);
            return null;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("bait", hasBait());
            return tag;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            setBait(nbt.func_74767_n("bait"));
        }
    }
}
