package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.util.ReflectionLib;
import betterwithmods.util.StackIngredient;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionHelper.MixPredicate;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class HCBrewing extends Feature {
    private static boolean removeMovementPotions;
    private static boolean waterBreathingAnyFish;
    private static boolean removeWitchPotionDrops;
    private static boolean modPotionCompat;
    private static int potionStackSize;
    private boolean tryChangePotions;

    @Override
    public void setupConfig() {
        removeMovementPotions = loadPropBool("Remove Movement Potions", "Removes recipes for Speed and Leaping potions.", true);
        waterBreathingAnyFish = loadPropBool("Water Breathing Any Fish", "Any fish works for brewing Water Breathing potions.", true);
        removeWitchPotionDrops = loadPropBool("Remove Witch Ingredient Drops", "Removes redstone and glowstone from witch drops", true);
        modPotionCompat = loadPropBool("Modded Potion Compatibility", "Similarly modifies non-vanilla potions.", true);
        potionStackSize = loadPropInt("Potion Stacksize", "Maximum stacksize of potion items.", 8);
    }

    @Override
    public String getFeatureDescription() {
        return "Modifies and rebalances vanilla brewing recipes and makes potions stack up to 8.";
    }

    private boolean isWitchDropBlacklisted(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151114_aO || item == Items.field_151102_aT || item == Items.field_151070_bp || item == Items.field_151016_H;
    }

    @SubscribeEvent(priority = EventPriority.HIGH)
    public void mobDrops(LivingDropsEvent evt) {
        Entity entity = evt.getEntityLiving();
        List<EntityItem> drops = evt.getDrops();

        if (entity instanceof EntityWitch) {
            Iterator<EntityItem> iterator = drops.iterator();
            while (iterator.hasNext()) {
                EntityItem item = iterator.next();
                ItemStack stack = item.func_92059_d();
                if (removeWitchPotionDrops && isWitchDropBlacklisted(stack))
                    iterator.remove();
                else if (stack.func_77973_b() == Items.field_151137_ax)
                    item.func_92058_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART, stack.func_190916_E()));
            }
        }

        if (entity instanceof EntitySquid) {
            if (entity.field_70170_p.field_73012_v.nextInt(100) < 10) {
                entity.func_70099_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND), 0);
            }
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        tryChangePotions = true;

        List<MixPredicate<PotionType>> moddedPotions;
        List<MixPredicate<PotionType>> mixPredicates;

        mixPredicates = ReflectionHelper.getPrivateValue(PotionHelper.class, null, ReflectionLib.POTIONHELPER_TYPE_CONVERSIONS);
        List<MixPredicate<Item>> mixItemPredicates = ReflectionHelper.getPrivateValue(PotionHelper.class, null, ReflectionLib.POTIONHELPER_ITEM_CONVERSIONS);
        //List<PotionHelper.ItemPredicateInstance> potionItems = (List<PotionHelper.ItemPredicateInstance>) ReflectionHelper.findField(PotionHelper.class,"field_185215_c","POTION_ITEMS").get(null);

        moddedPotions = mixPredicates.stream().filter(this::isModdedPotion).collect(Collectors.toList());

        mixPredicates.clear();
        mixItemPredicates.clear();
        //potionItems.clear(); //Don't clear this, this is just potion-related crap

        Items.field_151068_bn.func_77625_d(potionStackSize);
        Items.field_185155_bH.func_77625_d(potionStackSize);
        Items.field_185156_bI.func_77625_d(potionStackSize);

        if (tryChangePotions) {
            Ingredient extender = convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART));
            Ingredient strenthener = convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE));
            Ingredient inverter = convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC));
            Ingredient awkward = convertToPotionItem(Items.field_151075_bm);
            Ingredient fireResistance = convertToPotionItem(Items.field_151064_bs);
            Ingredient nightVision = convertToPotionItem(Items.field_151070_bp);
            Ingredient poison = convertToPotionItem(Blocks.field_150337_Q);
            Ingredient regeneration = convertToPotionItem(Items.field_151073_bk);
            Ingredient strength = convertToPotionItem(Items.field_151065_br);
            Ingredient swiftness = convertToPotionItem(Items.field_151102_aT);
            Ingredient leaping = convertToPotionItem(Items.field_179556_br);
            Ingredient waterBreathing = convertToPotionItem(new ItemStack(Items.field_151115_aP, ItemFishFood.FishType.PUFFERFISH.func_150976_a()));
            if (waterBreathingAnyFish)
                waterBreathing = convertToPotionItem(Items.field_151115_aP);
            Ingredient healing = convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND));

            PotionHelper.func_193355_a(Items.field_151068_bn, BWMItems.CREEPER_OYSTER, Items.field_185155_bH);
            PotionHelper.func_193355_a(Items.field_185155_bH, Items.field_185157_bK, Items.field_185156_bI);

            PotionHelper.func_193356_a(PotionTypes.field_185230_b, awkward, PotionTypes.field_185233_e);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, extender, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, strenthener, PotionTypes.field_185232_d);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, fireResistance, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, nightVision, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, poison, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, regeneration, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, strength, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, swiftness, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, leaping, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, waterBreathing, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, healing, PotionTypes.field_185231_c);
            PotionHelper.func_193356_a(PotionTypes.field_185230_b, inverter, PotionTypes.field_185231_c);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, fireResistance, PotionTypes.field_185241_m);
            PotionHelper.func_193356_a(PotionTypes.field_185241_m, extender, PotionTypes.field_185242_n);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, nightVision, PotionTypes.field_185234_f);
            PotionHelper.func_193356_a(PotionTypes.field_185234_f, extender, PotionTypes.field_185235_g);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, poison, PotionTypes.field_185254_z);
            PotionHelper.func_193356_a(PotionTypes.field_185254_z, strenthener, PotionTypes.field_185219_B);
            PotionHelper.func_193356_a(PotionTypes.field_185254_z, extender, PotionTypes.field_185218_A);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, regeneration, PotionTypes.field_185220_C);
            PotionHelper.func_193356_a(PotionTypes.field_185220_C, extender, PotionTypes.field_185221_D);
            PotionHelper.func_193356_a(PotionTypes.field_185220_C, strenthener, PotionTypes.field_185222_E);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, strength, PotionTypes.field_185223_F);
            PotionHelper.func_193356_a(PotionTypes.field_185223_F, strenthener, PotionTypes.field_185225_H);
            PotionHelper.func_193356_a(PotionTypes.field_185223_F, extender, PotionTypes.field_185224_G);

            if (!removeMovementPotions) {
                PotionHelper.func_193356_a(PotionTypes.field_185233_e, swiftness, PotionTypes.field_185243_o);
                PotionHelper.func_193356_a(PotionTypes.field_185243_o, strenthener, PotionTypes.field_185245_q);
                PotionHelper.func_193356_a(PotionTypes.field_185243_o, extender, PotionTypes.field_185244_p);

                PotionHelper.func_193356_a(PotionTypes.field_185233_e, leaping, PotionTypes.field_185238_j);
                PotionHelper.func_193356_a(PotionTypes.field_185238_j, extender, PotionTypes.field_185239_k);
                PotionHelper.func_193356_a(PotionTypes.field_185238_j, strenthener, PotionTypes.field_185240_l);

                PotionHelper.func_193356_a(PotionTypes.field_185243_o, inverter, PotionTypes.field_185246_r);
                PotionHelper.func_193356_a(PotionTypes.field_185245_q, inverter, PotionTypes.field_185246_r);
                PotionHelper.func_193356_a(PotionTypes.field_185244_p, inverter, PotionTypes.field_185247_s);
                PotionHelper.func_193356_a(PotionTypes.field_185238_j, inverter, PotionTypes.field_185246_r);
                PotionHelper.func_193356_a(PotionTypes.field_185240_l, inverter, PotionTypes.field_185246_r);
                PotionHelper.func_193356_a(PotionTypes.field_185239_k, inverter, PotionTypes.field_185247_s);
                PotionHelper.func_193356_a(PotionTypes.field_185246_r, extender, PotionTypes.field_185247_s);
            }

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, waterBreathing, PotionTypes.field_185248_t);
            PotionHelper.func_193356_a(PotionTypes.field_185248_t, extender, PotionTypes.field_185249_u);

            PotionHelper.func_193356_a(PotionTypes.field_185233_e, healing, PotionTypes.field_185250_v);
            PotionHelper.func_193356_a(PotionTypes.field_185250_v, strenthener, PotionTypes.field_185251_w);

            PotionHelper.func_193356_a(PotionTypes.field_185250_v, inverter, PotionTypes.field_185252_x);
            PotionHelper.func_193356_a(PotionTypes.field_185251_w, inverter, PotionTypes.field_185253_y);
            PotionHelper.func_193356_a(PotionTypes.field_185254_z, inverter, PotionTypes.field_185252_x);
            PotionHelper.func_193356_a(PotionTypes.field_185218_A, inverter, PotionTypes.field_185252_x);
            PotionHelper.func_193356_a(PotionTypes.field_185219_B, inverter, PotionTypes.field_185253_y);
            PotionHelper.func_193356_a(PotionTypes.field_185252_x, strenthener, PotionTypes.field_185253_y);

            PotionHelper.func_193356_a(PotionTypes.field_185223_F, inverter, PotionTypes.field_185226_I);
            PotionHelper.func_193356_a(PotionTypes.field_185225_H, inverter, PotionTypes.field_185226_I);
            PotionHelper.func_193356_a(PotionTypes.field_185224_G, inverter, PotionTypes.field_185227_J);
            PotionHelper.func_193356_a(PotionTypes.field_185226_I, extender, PotionTypes.field_185227_J);

            PotionHelper.func_193356_a(PotionTypes.field_185234_f, inverter, PotionTypes.field_185236_h);
            PotionHelper.func_193356_a(PotionTypes.field_185235_g, inverter, PotionTypes.field_185237_i);
            PotionHelper.func_193356_a(PotionTypes.field_185236_h, extender, PotionTypes.field_185237_i);

            if (modPotionCompat) {
                ItemStack extenderToReplace = new ItemStack(Items.field_151137_ax);
                ItemStack strengthenerToReplace = new ItemStack(Items.field_151114_aO);
                ItemStack inverterToReplace = new ItemStack(Items.field_151071_bq);
                ItemStack splashToReplace = new ItemStack(Items.field_151016_H);

                for (MixPredicate<PotionType> moddedPotion : moddedPotions) {
                    if (moddedPotion.field_185199_b.apply(extenderToReplace) && isExtended(moddedPotion.field_185198_a.func_185170_a(), moddedPotion.field_185200_c.func_185170_a()))
                        moddedPotion.field_185199_b = extender;
                    if (moddedPotion.field_185199_b.apply(strengthenerToReplace) && isStrong(moddedPotion.field_185198_a.func_185170_a(), moddedPotion.field_185200_c.func_185170_a()))
                        moddedPotion.field_185199_b = strenthener;
                    if (moddedPotion.field_185199_b.apply(inverterToReplace) && isInverted(moddedPotion.field_185198_a.func_185170_a(), moddedPotion.field_185200_c.func_185170_a()))
                        moddedPotion.field_185199_b = inverter;
                    mixPredicates.add(moddedPotion);
                }

                List<IBrewingRecipe> recipes = ReflectionHelper.getPrivateValue(BrewingRecipeRegistry.class, null,"recipes");
                ListIterator<IBrewingRecipe> iterator = recipes.listIterator();

                while (iterator.hasNext()) {
                    IBrewingRecipe recipe = iterator.next();
                    if (recipe instanceof AbstractBrewingRecipe) {
                        AbstractBrewingRecipe abstractRecipe = (AbstractBrewingRecipe) recipe;
                        if (abstractRecipe.isIngredient(extenderToReplace) && isExtended(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                            iterator.remove();
                            iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART), abstractRecipe.getOutput()));
                        } else if (abstractRecipe.isIngredient(strengthenerToReplace) && isStrong(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                            iterator.remove();
                            iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE), abstractRecipe.getOutput()));
                        } else if (abstractRecipe.isIngredient(inverterToReplace) && isInverted(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                            iterator.remove();
                            iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC), abstractRecipe.getOutput()));
                        } else if (abstractRecipe.isIngredient(splashToReplace) && isSplash(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                            iterator.remove();
                            iterator.add(new BrewingRecipe(abstractRecipe.getInput(), new ItemStack(BWMItems.CREEPER_OYSTER), abstractRecipe.getOutput()));
                        }
                    }
                }
            }
        }
    }

    private boolean isModdedPotion(MixPredicate<PotionType> predicate) {
        ResourceLocation registryName = predicate.field_185200_c.getRegistryName();
        //If there's no registry name it's surely modded as only modders make dumb mistakes like that
        return registryName == null || (!registryName.func_110624_b().toLowerCase().equals("minecraft") && !registryName.func_110624_b().toLowerCase().equals("betterwithmods"));
    }

    public boolean isExtended(ItemStack potionA, ItemStack potionB) {
        List<PotionEffect> effectsA = PotionUtils.func_185189_a(potionA);
        List<PotionEffect> effectsB = PotionUtils.func_185189_a(potionB);

        return isExtended(effectsA, effectsB); //Not equal because of fuse potions in Extra Alchemy
    }

    private boolean isExtended(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1)
            return false;

        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);

        return isExtended(effectA, effectB);
    }

    private boolean isExtended(PotionEffect effectA, PotionEffect effectB) {
        return effectA.func_188419_a().equals(effectB.func_188419_a()) && effectA.func_76459_b() != effectB.func_76459_b();
    }

    public boolean isStrong(ItemStack potionA, ItemStack potionB) {
        List<PotionEffect> effectsA = PotionUtils.func_185189_a(potionA);
        List<PotionEffect> effectsB = PotionUtils.func_185189_a(potionB);

        return isStrong(effectsA, effectsB);
    }

    private boolean isStrong(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1)
            return false;

        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);

        return isStrong(effectA, effectB);
    }

    private boolean isStrong(PotionEffect effectA, PotionEffect effectB) {
        return effectA.func_188419_a().equals(effectB.func_188419_a()) && effectA.func_76458_c() < effectB.func_76458_c();
    }

    public boolean isInverted(ItemStack potionA, ItemStack potionB) {
        List<PotionEffect> effectsA = PotionUtils.func_185189_a(potionA);
        List<PotionEffect> effectsB = PotionUtils.func_185189_a(potionB);

        return isInverted(effectsA, effectsB);
    }

    private boolean isInverted(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1)
            return false;

        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);

        return isInverted(effectA, effectB);
    }

    private boolean isInverted(PotionEffect effectA, PotionEffect effectB) {
        return !effectA.func_188419_a().equals(effectB.func_188419_a());
    }

    public boolean isSplash(ItemStack potionA, ItemStack potionB) {
        List<PotionEffect> effectsA = PotionUtils.func_185189_a(potionA);
        List<PotionEffect> effectsB = PotionUtils.func_185189_a(potionB);

        if (effectsA.size() != 1 || effectsB.size() != 1)
            return false;

        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);

        return effectA.func_188419_a().equals(effectB.func_188419_a()) && potionB.func_77973_b() instanceof ItemSplashPotion;
    }

    public Ingredient convertToPotionItem(ItemStack stack) {

        return StackIngredient.fromStacks(stack);
    }

    public Ingredient convertToPotionItem(Item item) {
        return Ingredient.func_193367_a(item);
    }

    public Ingredient convertToPotionItem(Block block) {
        return Ingredient.func_193367_a(Item.func_150898_a(block));
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}
