package betterwithmods.module.hardcore.crafting;

import betterwithmods.api.tile.IHeated;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.bulk.recipes.BulkCraftEvent;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.module.Feature;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemStackHandler;

public class ExplosiveRecipes extends Feature {

    @Override
    public String getFeatureDescription() {
        return "Some recipes can't get too hot or they might explode.";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onBulkCraft(BulkCraftEvent event) {
        if (event.getTile() instanceof IHeated && event.getRecipe() instanceof CookingPotRecipe) {
            CookingPotRecipe recipe = (CookingPotRecipe) event.getRecipe();
            if (((IHeated) event.getTile()).getHeat(event.getWorld(), event.getTile().func_174877_v()) > recipe.getHeat()) {
                explodeCauldron(event.getWorld(), event.getTile().func_174877_v(), event.getInventory());
            }
        }
    }

    private void explodeCauldron(World world, BlockPos pos, ItemStackHandler inv) {
        float expSize = 0.0f;
        int blockAmt = 0;

        for (int i = 0; i < inv.getSlots(); i++) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b())
                continue;
            else if (BWOreDictionary.isOre(stack, "listAllExplosives")) {
                if (stack.func_77973_b() instanceof ItemBlock)
                    blockAmt += stack.func_190916_E();
                else
                    expSize += stack.func_190916_E() / 64f;
            }
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }

        expSize = blockAmt == 0 ? Math.max(expSize, 2.0f) : Math.max(expSize, 4.0f) + blockAmt;
        world.func_72876_a(null, pos.func_177958_n() + 0.5, pos.func_177956_o() + 0.5, pos.func_177952_p() + 0.5, expSize, true);
    }
}
