package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.blocks.tile.TileEntityBeacon;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

/**
 * Created by primetoxinz on 7/17/17.
 */
public class SpawnBeaconEffect implements IBeaconEffect {

    public static final HashMap<BlockPos, HashSet<BindingPoint>> SPAWN_LIST = Maps.newHashMap();


    public static void removeAll(BlockPos pos) {
        SPAWN_LIST.remove(pos);
    }

    public static void addPoint(BlockPos pos, BindingPoint point) {
        if (SPAWN_LIST.containsKey(pos)) {
            HashSet<BindingPoint> points = SPAWN_LIST.get(pos);
            if (!containsEntry(pos, point))
                points.add(point);
            SPAWN_LIST.put(pos, points);
        } else {
            SPAWN_LIST.put(pos, Sets.newHashSet(point));
        }
    }

    public static boolean containsEntry(BlockPos pos, BindingPoint point) {
        if (SPAWN_LIST.containsKey(pos)) {
            HashSet<BindingPoint> points = SPAWN_LIST.get(pos);
            return points.contains(point);
        }
        return false;
    }

    public static boolean shouldSpawnHere(BlockPos beacon, EntityPlayer player, World world) {
        if (SPAWN_LIST.containsKey(beacon)) {
            Set<BindingPoint> points = SPAWN_LIST.get(beacon);
            for (BindingPoint point : points) {
                if (point.canSpawn(beacon, player, world))
                    return true;
            }
        }
        return false;
    }

    @Override
    public boolean processInteractions(World world, BlockPos pos, int level, EntityPlayer player, ItemStack stack) {
        BindingPoint point = new BindingPoint(player, level);
        if (!containsEntry(pos, point))
            addPoint(pos, point);
        return true;
    }

    @Override
    public void effect(World world, BlockPos pos, int level) {
        //TODO Blight
    }

    public static class BindingPoint implements INBTSerializable<NBTTagCompound> {

        private UUID uuid;
        private SpawnType type;


        public BindingPoint(EntityPlayer player, int level) {
            this(player.func_146103_bH().getId(), SpawnType.VALUES[level]);
        }

        public BindingPoint(UUID uuid, SpawnType type) {
            this.uuid = uuid;
            this.type = type;
        }

        public BindingPoint(NBTTagCompound compound) {
            deserializeNBT(compound);
        }

        public boolean canSpawn(BlockPos beacon, EntityPlayer player, World world) {
            TileEntity tile = world.func_175625_s(beacon);
            if (isPlayer(player) && (tile instanceof TileEntityBeacon) && (((TileEntityBeacon) tile).func_191979_s() - 1) == type.ordinal())
                return type.inRange(beacon, player, world);
            return false;
        }

        public boolean isPlayer(EntityPlayer player) {
            return player.func_146103_bH() != null && player.func_146103_bH().getId().equals(uuid);
        }

        @Override
        public boolean equals(Object o) {
            return this.hashCode() == o.hashCode();
        }

        @Override
        public int hashCode() {
            return uuid.hashCode() ^ type.hashCode();
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", type.ordinal());
            tag.func_74778_a("uuid", uuid.toString());
            return tag;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            this.type = SpawnType.VALUES[nbt.func_74762_e("type")];
            this.uuid = UUID.fromString(nbt.func_74779_i("uuid"));
        }
    }

    public enum SpawnType {

        LEVEL1(40),
        LEVEL2(160),
        LEVEL3(-1),
        LEVEL4(-2);

        int range;

        SpawnType(int range) {
            this.range = range;
        }

        public boolean inRange(BlockPos beacon, EntityPlayer player, World world) {
            switch (this.range) {
                case -1:
                    return player.field_71093_bK == world.field_73011_w.getDimension();
                case -2:
                    return true;
                default:
                    double d = player.func_70011_f(beacon.func_177958_n(), beacon.func_177956_o(), beacon.func_177952_p());
                    return d <= this.range;
            }
        }

        public static SpawnType[] VALUES = values();
    }
}
