package betterwithmods.module.hardcore.beacons;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

@SideOnly(Side.CLIENT)
public class CompassProperty implements IItemPropertyGetter {
    private double rotation;
    private double rota;
    private long lastUpdateTick;

    @SideOnly(Side.CLIENT)
    public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0F;
        } else {
            boolean flag = entityIn != null;
            Entity entity = flag ? entityIn : stack.func_82836_z();

            if (worldIn == null) {
                worldIn = entity.field_70170_p;
            }
            double d0;

            if (worldIn.field_73011_w.func_76569_d()) {
                double d1 = flag ? (double) entity.field_70177_z : this.getFrameRotation((EntityItemFrame) entity);
                d1 = MathHelper.func_191273_b(d1 / 360.0D, 1.0D);

                CapabilityBeacon beacons = worldIn.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
                double angle = 0;
                if (beacons != null) {
                    angle = this.getAngleToPos(beacons.getClosest(worldIn, entity), entity);
                } else {
                    angle = this.getSpawnToAngle(worldIn, entity);
                }
                d0 = 0.5D - (d1 - 0.25D - angle);
            } else {
                d0 = Math.random();
            }

            if (flag) {
                d0 = this.wobble(worldIn, d0);
            }

            return MathHelper.func_188207_b((float) d0, 1.0F);
        }
    }

    @SideOnly(Side.CLIENT)
    private double wobble(World worldIn, double p_185093_2_) {
        if (worldIn.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = worldIn.func_82737_E();
            double d0 = p_185093_2_ - this.rotation;
            d0 = MathHelper.func_191273_b(d0 + 0.5D, 1.0D) - 0.5D;
            this.rota += d0 * 0.1D;
            this.rota *= 0.8D;
            this.rotation = MathHelper.func_191273_b(this.rotation + this.rota, 1.0D);
        }

        return this.rotation;
    }

    @SideOnly(Side.CLIENT)
    private double getFrameRotation(EntityItemFrame p_185094_1_) {
        return (double) MathHelper.func_188209_b(180 + p_185094_1_.field_174860_b.func_176736_b() * 90);
    }

    @SideOnly(Side.CLIENT)
    private double getSpawnToAngle(World world, Entity entity) {
        return getAngleToPos(world.func_175694_M(), entity);
    }

    private double getAngleToPos(BlockPos pos, Entity entity) {
        return Math.atan2((double) pos.func_177952_p() - entity.field_70161_v, (double) pos.func_177958_n() - entity.field_70165_t) / (Math.PI * 2D);
    }
}
