package betterwithmods.module.hardcore.beacons;

import com.google.common.collect.Maps;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CapabilityBeacon implements ICapabilitySerializable<NBTTagCompound> {

    @CapabilityInject(CapabilityBeacon.class)
    public static Capability<CapabilityBeacon> BEACON_CAPABILITY = null;

    private HashMap<Long, Integer> beacons = Maps.newHashMap();

    public CapabilityBeacon() {
    }

    public void addBeacon(BlockPos pos, int level) {
        beacons.put(pos.func_177986_g(), level);
    }

    public void removeBeacon(BlockPos pos) {
        beacons.remove(pos.func_177986_g());
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == BEACON_CAPABILITY)
            return true;
        return false;
    }

    @Nullable
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (hasCapability(capability, facing))
            return BEACON_CAPABILITY.cast(this);
        return null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagList list = new NBTTagList();

        for (Map.Entry<Long, Integer> entry : beacons.entrySet()) {
            list.func_74742_a(writeBeaconEntry(entry.getKey(), entry.getValue()));
        }

        tags.func_74782_a("list", list);
        return tags;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("list", 10);
        for (Iterator<NBTBase> it = list.iterator(); it.hasNext(); ) {
            NBTTagCompound tag = (NBTTagCompound) it.next();
            Pair<Long, Integer> b = readBeaconEntry(tag);
            beacons.put(b.getKey(), b.getValue());
        }
    }

    private static NBTTagCompound writeBeaconEntry(Long pos, int level) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", pos);
        tag.func_74768_a("level", level);
        return tag;
    }

    private static Pair<Long, Integer> readBeaconEntry(NBTTagCompound tag) {
        return Pair.of(tag.func_74763_f("pos"), tag.func_74762_e("level"));
    }

    public BlockPos getClosest(World world, Entity player) {
        if (beacons.isEmpty())
            return world.func_175694_M();
        BlockPos pos = BlockPos.func_177969_a(beacons.keySet().stream().min(Comparator.comparingDouble(p -> BlockPos.func_177969_a(p).func_177951_i(player.func_180425_c()))).orElse(world.func_175694_M().func_177986_g()));
        return pos;
    }

    public static class Storage implements Capability.IStorage<CapabilityBeacon> {

        @Nullable
        @Override
        public NBTBase writeNBT(Capability<CapabilityBeacon> capability, CapabilityBeacon instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        @Override
        public void readNBT(Capability<CapabilityBeacon> capability, CapabilityBeacon instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound) nbt);
        }
    }
}


