package betterwithmods.module.gameplay.miniblocks.tiles;

import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

import javax.annotation.Nullable;

public abstract class TileMini extends TileBasic {

    public IBlockState state;
    public BaseOrientation orientation;

    public TileMini() {
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);

        if (state != null) {
            NBTTagCompound texture = new NBTTagCompound();
            NBTUtil.func_190009_a(texture, state);
            tag.func_74782_a("texture", texture);
        } else {
            field_145850_b.func_175698_g(field_174879_c);
        }
        if (orientation != null) {
            tag.func_74768_a("orientation", orientation.ordinal());
        } else {
            field_145850_b.func_175698_g(field_174879_c);
        }
        return tag;
    }

    public abstract BaseOrientation deserializeOrientation(NBTTagCompound tag);

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("texture")) {
            state = NBTUtil.func_190008_d(compound.func_74775_l("texture"));
        } else {
            field_145850_b.func_175698_g(field_174879_c);
        }
        orientation = deserializeOrientation(compound);
        super.func_145839_a(compound);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        loadFromStack(stack);
        if (func_145838_q() instanceof BlockMini)
            orientation = ((BlockMini) func_145838_q()).getOrientationFromPlacement(placer, face, stack, hitX, hitY, hitZ);
    }

    public void loadFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("texture");
        if (tag != null) {
            state = NBTUtil.func_190008_d(tag);
        }
    }

    public boolean changeOrientation(BaseOrientation newOrientation, boolean simulate) {
        if (orientation != newOrientation) {
            if (!simulate) {
                orientation = newOrientation;
                markBlockForUpdate();
                func_145831_w().func_175722_b(field_174879_c, func_145838_q(), true);
            }
            return true;
        } else {
            return false;
        }
    }

    public void markBlockForRenderUpdate() {
        field_145850_b.func_175704_b(field_174879_c, field_174879_c);
    }

    public void markBlockForUpdate() {
        IBlockState state = field_145850_b.func_180495_p(field_174879_c);
        field_145850_b.func_184138_a(field_174879_c, state, state, 3);
    }

    public BaseOrientation getOrientation() {
        if (orientation == null)
            return BaseOrientation.DEFAULT;
        return orientation;
    }

    public IBlockState getState() {
        if (state == null)
            return Blocks.field_150350_a.func_176223_P();
        return state;
    }

    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target, IBlockState state) {
        if (this.state != null && func_145838_q() instanceof BlockMini) {
            return MiniBlocks.fromParent(func_145838_q(), this.getState());
        }
        return ItemStack.field_190927_a;
    }

}
