package betterwithmods.module.gameplay.miniblocks.orientations;

import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface BaseOrientation extends IStringSerializable {
    BaseOrientation DEFAULT = new BaseOrientation() {
        @SideOnly(Side.CLIENT)
        @Override
        public TRSRTransformation toTransformation() {
            return new TRSRTransformation(EnumFacing.UP);
        }

        @Override
        public String func_176610_l() {
            return "default";
        }

        @Override
        public AxisAlignedBB getBounds() {
            return Block.field_185505_j;
        }
    };


    default int ordinal() {
        return 0;
    }

    default AxisAlignedBB getBounds() {
        return Block.field_185505_j;
    }

    @SideOnly(Side.CLIENT)
    TRSRTransformation toTransformation();

    default BaseOrientation next() {
        return DEFAULT;
    }

}
