package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockUnfiredPottery;
import betterwithmods.common.registry.TurntableRotationManager;
import betterwithmods.module.Feature;
import com.google.common.collect.Lists;
import net.minecraft.block.*;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

/**
 * Created by primetoxinz on 5/16/17.
 */
public class TurntableRecipes extends Feature {
    public TurntableRecipes() {
        canDisable = false;
    }

    @Override
    public void init(FMLInitializationEvent event) {

        BWRegistry.TURNTABLE.addDefaultRecipe(new ItemStack(Blocks.field_150435_aG), BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.CRUCIBLE), Lists.newArrayList(new ItemStack(Items.field_151119_aD)));
        BWRegistry.TURNTABLE.addDefaultRecipe(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.CRUCIBLE), BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.PLANTER));
        BWRegistry.TURNTABLE.addDefaultRecipe(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.PLANTER), BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.VASE), Lists.newArrayList(new ItemStack(Items.field_151119_aD)));
        BWRegistry.TURNTABLE.addDefaultRecipe(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.VASE), BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.URN), Lists.newArrayList(new ItemStack(Items.field_151119_aD)));
        BWRegistry.TURNTABLE.addDefaultRecipe(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.URN), Blocks.field_150350_a.func_176223_P(),Lists.newArrayList(new ItemStack(Items.field_151119_aD)));


        TurntableRotationManager.addAttachment(b -> b instanceof BlockTorch);
        TurntableRotationManager.addAttachment(b -> b instanceof BlockLever);
        TurntableRotationManager.addAttachment(b -> b instanceof BlockLadder);
        TurntableRotationManager.addAttachment(b -> b instanceof BlockButton);
        TurntableRotationManager.addAttachment(b -> b instanceof BlockWallSign);
        TurntableRotationManager.addAttachment(b -> b instanceof BlockTripWireHook);

        TurntableRotationManager.addRotationHandler(block -> block instanceof BlockTorch, (world, pos) -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177229_b(BlockTorch.field_176596_a).func_176740_k().func_176720_b();
        });
        TurntableRotationManager.addRotationHandler(Blocks.field_150442_at, (world, pos) -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177229_b(BlockLever.field_176360_a).func_176852_c().func_176740_k().func_176720_b();
        });
        TurntableRotationManager.addRotationBlacklist(block -> block instanceof BlockPistonExtension);
        TurntableRotationManager.addRotationHandler(BWMBlocks.UNFIRED_POTTERY, new TurntableRotationManager.IRotation() {
            @Override
            public boolean isValid(World world, BlockPos pos) {
                return true;
            }

            @Override
            public boolean canTransmitHorizontally(World world, BlockPos pos) {
                return false;
            }

            @Override
            public boolean canTransmitVertically(World world, BlockPos pos) {
                return false;
            }
        });
        TurntableRotationManager.addRotationHandler(Blocks.field_150435_aG, new TurntableRotationManager.IRotation() {
            @Override
            public boolean isValid(World world, BlockPos pos) {
                return true;
            }

            @Override
            public boolean canTransmitHorizontally(World world, BlockPos pos) {
                return false;
            }

            @Override
            public boolean canTransmitVertically(World world, BlockPos pos) {
                return false;
            }
        });
        TurntableRotationManager.addRotationHandler(block -> block instanceof BlockPistonBase, (world, pos) -> !world.func_180495_p(pos).func_177229_b(BlockPistonBase.field_176320_b));
    }
}
