package betterwithmods.module.gameplay;

import betterwithmods.BWMod;
import betterwithmods.common.BWMItems;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

import java.util.Locale;

public class ReadTheFingManual extends Feature {
    @SubscribeEvent
    public void onCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        if (!event.player.field_70170_p.field_72995_K && !event.crafting.func_190926_b() && event.crafting.func_77973_b() != BWMItems.MANUAL) {
            ResourceLocation name = event.crafting.func_77973_b().getRegistryName();
            if (name != null && name.toString().toLowerCase(Locale.ROOT).contains(BWMod.MODID)) {
                PlayerDataHandler.PlayerInfo save = PlayerDataHandler.getPlayerInfo(event.player);
                if (save != null && !save.givenManual) {
                    save.givenManual = true;
                    InvUtils.spawnStack(event.player.field_70170_p, event.player.func_180425_c(), new ItemStack(BWMItems.MANUAL), 10);
                    event.player.func_145747_a(new TextComponentTranslation("bwm.manual.message"));
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Gives the Player a BWM Manual the first time they craft an item from BWM";
    }
}
