package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.needs.HCTools;
import com.google.common.collect.Lists;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

import java.util.List;

/**
 * Created by primetoxinz on 4/20/17.
 */
public class MetalReclaming extends Feature {
    public static int reclaimCount;

    public static void addReclaimRecipe(ItemStack input, String oreSuffix, int ingotCount) {
        int totalNuggets = ingotCount * reclaimCount;
        int ingots = totalNuggets / 9;
        int nuggets = totalNuggets % 9;
        ItemStack ingotStack = ItemStack.field_190927_a;
        ItemStack nuggetStack = ItemStack.field_190927_a;
        if (ingots > 0 && !OreDictionary.getOres("ingot" + oreSuffix).isEmpty())
            ingotStack = OreDictionary.getOres("ingot" + oreSuffix).get(0);
        if (nuggets > 0 && !OreDictionary.getOres("nugget" + oreSuffix).isEmpty())
            nuggetStack = OreDictionary.getOres("nugget" + oreSuffix).get(0);
        List<ItemStack> outputs = Lists.newArrayList();
        if (ingotStack.func_190926_b()) {
            if (!nuggetStack.func_190926_b()) {
                outputs.add(new ItemStack(nuggetStack.func_77973_b(), totalNuggets > nuggets ? totalNuggets : nuggets, nuggetStack.func_77960_j()));
            }
        } else {
            outputs.add(new ItemStack(ingotStack.func_77973_b(), ingots, ingotStack.func_77960_j()));
            if (!nuggetStack.func_190926_b())
                outputs.add(new ItemStack(nuggetStack.func_77973_b(), nuggets, nuggetStack.func_77960_j()));
        }
        BWRegistry.CRUCIBLE.addStokedRecipe(input, outputs);
    }

    @Override
    public String getFeatureDescription() {
        return "Adds recipes to the Crucible to melt metal items back into their component metals";
    }

    @Override
    public void setupConfig() {
        reclaimCount = loadPropInt("Reclaming Count", "Amount (in nuggets per ingot) tools and armor in the crucible reclaim. Does not affect diamond or soulforged steel ingot reclamation. (Set to 0 to disable reclamation entirely.)", "", 6, 0, 9);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        int axe_amt = HCTools.changeAxeRecipe ? 2 : 3;

        if (reclaimCount > 0) {
//            BWRegistry.CRUCIBLE.addStokedRecipe();
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_HOE, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_SWORD, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_PICKAXE, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_AXE, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, axe_amt));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_SHOVEL, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_MATTOCK, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 4));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_BATTLEAXE, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 5));
            addReclaimRecipe(new ItemStack(Items.field_151030_Z, 1, OreDictionary.WILDCARD_VALUE), "Iron", 8);
            addReclaimRecipe(new ItemStack(Items.field_151036_c, 1, OreDictionary.WILDCARD_VALUE), "Iron", axe_amt);
            addReclaimRecipe(new ItemStack(Items.field_151167_ab, 1, OreDictionary.WILDCARD_VALUE), "Iron", 4);
            addReclaimRecipe(new ItemStack(Items.field_151028_Y, 1, OreDictionary.WILDCARD_VALUE), "Iron", 5);
            addReclaimRecipe(new ItemStack(Items.field_151165_aa, 1, OreDictionary.WILDCARD_VALUE), "Iron", 7);
            addReclaimRecipe(new ItemStack(Items.field_151019_K, 1, OreDictionary.WILDCARD_VALUE), "Iron", 2);
            addReclaimRecipe(new ItemStack(Items.field_151035_b, 1, OreDictionary.WILDCARD_VALUE), "Iron", 3);
            addReclaimRecipe(new ItemStack(Items.field_151037_a, 1, OreDictionary.WILDCARD_VALUE), "Iron", 1);
            addReclaimRecipe(new ItemStack(Items.field_151040_l, 1, OreDictionary.WILDCARD_VALUE), "Iron", 2);
            addReclaimRecipe(new ItemStack(Items.field_151171_ah, 1, OreDictionary.WILDCARD_VALUE), "Gold", 8);
            addReclaimRecipe(new ItemStack(Items.field_151006_E, 1, OreDictionary.WILDCARD_VALUE), "Gold", axe_amt);
            addReclaimRecipe(new ItemStack(Items.field_151151_aj, 1, OreDictionary.WILDCARD_VALUE), "Gold", 4);
            addReclaimRecipe(new ItemStack(Items.field_151169_ag, 1, OreDictionary.WILDCARD_VALUE), "Gold", 5);
            addReclaimRecipe(new ItemStack(Items.field_151149_ai, 1, OreDictionary.WILDCARD_VALUE), "Gold", 7);
            addReclaimRecipe(new ItemStack(Items.field_151013_M, 1, OreDictionary.WILDCARD_VALUE), "Gold", 2);
            addReclaimRecipe(new ItemStack(Items.field_151005_D, 1, OreDictionary.WILDCARD_VALUE), "Gold", 3);
            addReclaimRecipe(new ItemStack(Items.field_151011_C, 1, OreDictionary.WILDCARD_VALUE), "Gold", 1);
            addReclaimRecipe(new ItemStack(Items.field_151010_B, 1, OreDictionary.WILDCARD_VALUE), "Gold", 2);
            addReclaimRecipe(new ItemStack(Items.field_151097_aZ, 1, OreDictionary.WILDCARD_VALUE), "Iron", 2);

            BWRegistry.CRUCIBLE.addStokedRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_HELMET, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 10));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_CHEST, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 14));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_PANTS, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 12));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_BOOTS, 1, OreDictionary.WILDCARD_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 8));

            BWRegistry.CRUCIBLE.addStokedRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHAIN_MAIL), new ItemStack(Items.field_191525_da, 4));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151020_U, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_191525_da, 20));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151022_W, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_191525_da, 32));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151023_V, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_191525_da, 28));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151029_X, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_191525_da, 16));

            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_185159_cQ, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_151042_j, 1));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151139_aw), new ItemStack(Items.field_151042_j, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151138_bX, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_151042_j, 8));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151136_bY, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_151043_k, 8));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151143_au), new ItemStack(Items.field_151042_j, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151108_aI), new ItemStack(Items.field_151042_j, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151109_aJ), new ItemStack(Items.field_151042_j, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151140_bW), new ItemStack(Items.field_151042_j, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151142_bV), new ItemStack(Items.field_151042_j, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151066_bu), new ItemStack(Items.field_151042_j, 7));

            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150448_aq, 8), new ItemStack(Items.field_151042_j, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150318_D, 6), new ItemStack(Items.field_151043_k, 6));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150408_cc, 6), new ItemStack(Items.field_151042_j, 6));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150411_aY, 8), new ItemStack(Items.field_151042_j, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150467_bQ, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_151042_j, 31));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150438_bZ, 1, OreDictionary.WILDCARD_VALUE), new ItemStack(Items.field_151042_j, 5));

            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150443_bT, 1), new ItemStack(Items.field_151042_j, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150445_bS, 1), new ItemStack(Items.field_151043_k, 2));

            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.STEEL_ANVIL), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 7));
        }
    }
}
