package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreIngredient;

/**
 * Created by primetoxinz on 5/16/17.
 */
public class CrucibleRecipes extends Feature {
    public CrucibleRecipes() {
        canDisable = false;
    }

    @Override
    public void init(FMLInitializationEvent event) {

        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150348_b));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.COBBLE, 1, 0), new ItemStack(Blocks.field_150348_b,1,1));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.COBBLE, 1, 1), new ItemStack(Blocks.field_150348_b,1,3));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.COBBLE, 1, 2), new ItemStack(Blocks.field_150348_b,1,5));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.AESTHETIC, 1, 7), new ItemStack(BWMBlocks.AESTHETIC, 1, 6));

        BWRegistry.CRUCIBLE.addStokedRecipe(StackIngredient.fromOre(9, "nuggetDiamond"), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_INGOT));
        BWRegistry.CRUCIBLE.addStokedRecipe(StackIngredient.fromOre(9, "nuggetSoulforgedSteel"), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));

        BWRegistry.CRUCIBLE.addStokedRecipe(new OreIngredient("sand"), new ItemStack(Blocks.field_150359_w));
        BWRegistry.CRUCIBLE.addStokedRecipe(StackIngredient.fromStacks(new ItemStack(Blocks.field_150410_aZ,8)), new ItemStack(Blocks.field_150359_w,3));
    }

}
