package betterwithmods.module.compat.multipart;

import betterwithmods.common.BWMBlocks;
import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.MiniType;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockSiding;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.IWrappedBlock;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import mcmultipart.api.slot.EnumCenterSlot;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MCMPAddon()
public class BWMMCMP implements IMCMPAddon {

    @Override
    public void registerParts(IMultipartRegistry registry) {
//        MiniBlocks.MINI_MATERIAL_BLOCKS.keySet()
//        for (MiniType type : Sets.newHashSet(MiniType.SIDING)) {
//            for (BlockMini block : MiniBlocks.MINI_MATERIAL_BLOCKS.get(type).values()) {
//                IMultipart part = fromType(block, type);
//                if (part != null) {
//                    register(registry, block, part).setBlockPlacementLogic(this::placeSiding);
//                }
//            }
//        }

        register(registry, BWMBlocks.WOODEN_AXLE, new MultipartProxy(BWMBlocks.WOODEN_AXLE, state -> EnumCenterSlot.CENTER));
        register(registry, BWMBlocks.STEEL_AXLE, new MultipartProxy(BWMBlocks.STEEL_AXLE, state -> EnumCenterSlot.CENTER));
    }

    private boolean placeSiding(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMini && player.func_175151_a(pos, facing, stack) && world.func_190527_a(newState.func_177230_c(), pos, false, facing, (Entity) null)) {

            if (ItemMini.placeBlockAt((ItemMini) stack.func_77973_b(), stack, player, world, pos, facing, hitX, hitY, hitZ, newState)) {
                newState = world.func_180495_p(pos);
                SoundType soundtype = newState.func_177230_c().getSoundType(newState, world, pos, player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
                if (!player.func_184812_l_())
                    stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public IWrappedBlock register(IMultipartRegistry registry, Block block, IMultipart proxy) {
        registry.registerPartWrapper(block, proxy);
        return registry.registerStackWrapper(Item.func_150898_a(block), i -> true, block);
    }

    public IMultipart fromType(BlockMini mini, MiniType type) {
        switch (type) {
            case SIDING:
                return new MultipartSiding((BlockSiding) mini);
            case MOULDING:
                break;
            case CORNER:
                break;
            case UNKNOWN:
                break;
        }
        return null;
    }
}
