package betterwithmods.manual.common.item;

import betterwithmods.manual.api.detail.ManualDefinition;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import javax.annotation.Nullable;

/**
 * The manual!
 */
public final class ItemBookManual extends ItemBook {
    private final ManualDefinition myManual;

    public ItemBookManual() {
        myManual = ManualDefinitionImpl.INSTANCE;
    }

    public ItemBookManual(ManualDefinition m) {
        myManual = m;
    }

    public static boolean tryOpenManual(final ManualDefinition manual, final World world, final EntityPlayer player, @Nullable final String path) {
        if (path == null) {
            return false;
        }

        if (world.field_72995_K) {
            manual.openFor(player);
            manual.reset();
            manual.navigate(path);
        }

        return true;
    }

    @Deprecated
    public static boolean tryOpenManual(final World world, final EntityPlayer player, @Nullable final String path) {
        return tryOpenManual(ManualDefinitionImpl.INSTANCE, world, player, path);
    }

    // --------------------------------------------------------------------- //
    // Item

    @Override
    public EnumActionResult func_180614_a(final EntityPlayer player, final World world, final BlockPos pos, final EnumHand hand, final EnumFacing facing, final float hitX, final float hitY, final float hitZ) {
        return tryOpenManual(myManual, world, player, myManual.pathFor(world, pos)) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(final World world, final EntityPlayer player, final EnumHand hand) {
        if (world.field_72995_K) {
            if (player.func_70093_af()) {
                myManual.reset();
            }
            myManual.openFor(player);
            return ActionResult.newResult(EnumActionResult.SUCCESS, player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    // --------------------------------------------------------------------- //
    // ItemBook

    @Override
    public boolean func_77616_k(final ItemStack stack) {
        return false;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }
}
