package betterwithmods.manual.client.renderer.font;

import gnu.trove.map.TCharIntMap;
import gnu.trove.map.hash.TCharIntHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

/**
 * Base implementation for texture based font rendering.
 */
public abstract class AbstractFontRenderer implements FontRenderer {
    private final TCharIntMap CHAR_MAP;

    private final int COLUMNS = getResolution() / (getCharWidth() + getGapU());
    private final float U_SIZE = getCharWidth() / (float) getResolution();
    private final float V_SIZE = getCharHeight() / (float) getResolution();
    private final float U_STEP = (getCharWidth() + getGapU()) / (float) getResolution();
    private final float V_STEP = (getCharHeight() + getGapV()) / (float) getResolution();

    protected AbstractFontRenderer() {
        CHAR_MAP = new TCharIntHashMap();
        final CharSequence chars = getCharacters();
        for (int index = 0; index < chars.length(); index++) {
            CHAR_MAP.put(chars.charAt(index), index);
        }
    }

    // --------------------------------------------------------------------- //

    public void drawString(final CharSequence value) {
        drawString(value, value.length());
    }

    public void drawString(final CharSequence value, final int maxChars) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a(false);

        Minecraft.func_71410_x().func_110434_K().func_110577_a(getTextureLocation());

        final Tessellator tessellator = Tessellator.func_178181_a();
        final BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);

        float tx = 0f;
        final int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; i++) {
            final char ch = value.charAt(i);
            drawChar(tx, ch, buffer);
            tx += getCharWidth() + getGapU();
        }

        tessellator.func_78381_a();

        GlStateManager.func_179132_a(true);
        GlStateManager.func_179121_F();
    }

    // --------------------------------------------------------------------- //

    abstract protected CharSequence getCharacters();

    abstract protected ResourceLocation getTextureLocation();

    abstract protected int getResolution();

    abstract protected int getGapU();

    abstract protected int getGapV();

    // --------------------------------------------------------------------- //

    private void drawChar(final float x, final char ch, final BufferBuilder buffer) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        final int index = getCharIndex(ch);

        final int column = index % COLUMNS;
        final int row = index / COLUMNS;
        final float u = column * U_STEP;
        final float v = row * V_STEP;

        buffer.func_181662_b(x, getCharHeight(), 0).func_187315_a(u, v + V_SIZE).func_181675_d();
        buffer.func_181662_b(x + getCharWidth(), getCharHeight(), 0).func_187315_a(u + U_SIZE, v + V_SIZE).func_181675_d();
        buffer.func_181662_b(x + getCharWidth(), 0, 0).func_187315_a(u + U_SIZE, v).func_181675_d();
        buffer.func_181662_b(x, 0, 0).func_187315_a(u, v).func_181675_d();
    }

    private int getCharIndex(final char ch) {
        if (!CHAR_MAP.containsKey(ch)) {
            return CHAR_MAP.get('?');
        }
        return CHAR_MAP.get(ch);
    }
}
