package betterwithmods.manual.client.manual.segment.render;

import betterwithmods.manual.api.manual.ImageRenderer;
import com.google.common.base.Throwables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public class TextureImageRenderer implements ImageRenderer {
    private final ResourceLocation location;
    private final ImageTexture texture;

    public TextureImageRenderer(final ResourceLocation location) {
        this.location = location;

        final TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        final ITextureObject image = manager.func_110581_b(location);
        if (image instanceof ImageTexture) {
            this.texture = (ImageTexture) image;
        } else {
            if (image != null && image.func_110552_b() != -1) {
                TextureUtil.func_147942_a(image.func_110552_b());
            }
            this.texture = new ImageTexture(location);
            manager.func_110579_a(location, texture);
        }
    }

    @Override
    public int getWidth() {
        return texture.width;
    }

    @Override
    public int getHeight() {
        return texture.height;
    }

    @Override
    public void render(final int mouseX, final int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        GlStateManager.func_179131_c(1, 1, 1, 1);
        GL11.glBegin(GL11.GL_QUADS);
        GL11.glTexCoord2f(0, 0);
        GL11.glVertex2f(0, 0);
        GL11.glTexCoord2f(0, 1);
        GL11.glVertex2f(0, texture.height);
        GL11.glTexCoord2f(1, 1);
        GL11.glVertex2f(texture.width, texture.height);
        GL11.glTexCoord2f(1, 0);
        GL11.glVertex2f(texture.width, 0);
        GL11.glEnd();
    }

    private static class ImageTexture extends AbstractTexture {
        private final ResourceLocation location;
        private int width = 0;
        private int height = 0;

        public ImageTexture(final ResourceLocation location) {
            this.location = location;
        }

        @Override
        public void func_110551_a(final IResourceManager manager) throws IOException {
            func_147631_c();

            InputStream is = null;
            try {
                final IResource resource = manager.func_110536_a(location);
                is = resource.func_110527_b();
                final BufferedImage bi = ImageIO.read(is);
                TextureUtil.func_110989_a(func_110552_b(), bi, false, false);
                width = bi.getWidth();
                height = bi.getHeight();
            } catch (final Throwable t) {
                Throwables.propagate(t);
            } finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}
