package betterwithmods.manual.client.manual.segment.render;

import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.api.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public final class ItemStackImageRenderer implements ImageRenderer {
    /**
     * How long to show individual stacks, in milliseconds, before switching to the next.
     */
    private static final int CYCLE_SPEED = 1000;

    private final ItemStack[] stacks;

    public ItemStackImageRenderer(final ItemStack... stacks) {
        this.stacks = stacks;
    }

    @Override
    public int getWidth() {
        return 32;
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public void render(final int mouseX, final int mouseY) {
        final Minecraft mc = Minecraft.func_71410_x();
        final int index = (int) (System.currentTimeMillis() % (CYCLE_SPEED * stacks.length)) / CYCLE_SPEED;
        final ItemStack stack = stacks[index];

        GlStateManager.func_179152_a(getWidth() / 16f, getHeight() / 16f, getWidth() / 16f);
        GlStateManager.func_179091_B();
        RenderUtil.ignoreLighting();
        RenderHelper.func_74520_c();
        mc.func_175599_af().func_180450_b(stack, 0, 0);
        RenderHelper.func_74518_a();
    }
}
