package betterwithmods.manual.client.manual.segment;

import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.api.manual.InteractiveImageRenderer;
import betterwithmods.manual.client.manual.Document;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

import java.util.Optional;

public class RenderSegment extends AbstractSegment implements InteractiveSegment {
    private final Segment parent;
    private final String title;
    private final ImageRenderer imageRenderer;

    private int lastX = 0;
    private int lastY = 0;

    public RenderSegment(final Segment parent, final String title, final ImageRenderer imageRenderer) {
        super(parent.getManual());
        this.parent = parent;
        this.title = title;
        this.imageRenderer = imageRenderer;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    public Optional<String> tooltip() {
        if (imageRenderer instanceof InteractiveImageRenderer) {
            return Optional.of(((InteractiveImageRenderer) imageRenderer).getTooltip(title));
        } else {
            return Optional.of(title);
        }
    }

    @Override
    public boolean onMouseClick(final int mouseX, final int mouseY) {
        return imageRenderer instanceof InteractiveImageRenderer &&
                ((InteractiveImageRenderer) imageRenderer).onMouseClick(mouseX - lastX, mouseY - lastY);
    }

    @Override
    public void notifyHover() {
    }

    @Override
    public int nextY(final int indent, final int maxWidth, final FontRenderer renderer) {
        return imageHeight(maxWidth) + ((indent > 0) ? Document.lineHeight(renderer) : 0);
    }

    @Override
    public int nextX(final int indent, final int maxWidth, final FontRenderer renderer) {
        return 0;
    }

    @Override
    public Optional<InteractiveSegment> render(final int x, final int y, final int indent, final int maxWidth, final FontRenderer renderer, final int mouseX, final int mouseY) {
        final int width = imageWidth(maxWidth);
        final int height = imageHeight(maxWidth);
        final int xOffset = (maxWidth - width) / 2;
        final int yOffset = 2 + ((indent > 0) ? Document.lineHeight(renderer) : 0);
        final float s = scale(maxWidth);

        lastX = x + xOffset;
        lastY = y + yOffset;

        final Optional<InteractiveSegment> hovered = checkHovered(mouseX, mouseY, x + xOffset, y + yOffset, width, height);

        GlStateManager.func_179131_c(1, 1, 1, 1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(x + xOffset, y + yOffset, 0);
        GlStateManager.func_179152_a(s, s, s);

        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();

        if (hovered.isPresent()) {
            GlStateManager.func_179131_c(1, 1, 1, 0.15f);
            GlStateManager.func_179090_x();
            GL11.glBegin(GL11.GL_QUADS);
            GL11.glVertex2f(0, 0);
            GL11.glVertex2f(0, imageRenderer.getHeight());
            GL11.glVertex2f(imageRenderer.getWidth(), imageRenderer.getHeight());
            GL11.glVertex2f(imageRenderer.getWidth(), 0);
            GL11.glEnd();
            GlStateManager.func_179098_w();
        }

        GlStateManager.func_179131_c(1, 1, 1, 1);

        imageRenderer.render(mouseX - x, mouseY - y);

        GlStateManager.func_179121_F();

        return hovered;
    }

    @Override
    public String toString() {
        return String.format("![%s](%s)", title, imageRenderer);
    }

    private float scale(final int maxWidth) {
        return Math.min(1f, maxWidth / (float) imageRenderer.getWidth());
    }

    private int imageWidth(final int maxWidth) {
        return Math.min(maxWidth, imageRenderer.getWidth());
    }

    private int imageHeight(final int maxWidth) {
        return MathHelper.func_76123_f(imageRenderer.getHeight() * scale(maxWidth)) + 4;
    }
}
