package betterwithmods.manual.client.manual.provider;

import betterwithmods.BWMod;
import betterwithmods.manual.api.API;
import betterwithmods.manual.api.manual.ImageProvider;
import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.client.manual.segment.render.ItemStackImageRenderer;
import betterwithmods.manual.client.manual.segment.render.MissingItemRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OreDictImageProvider implements ImageProvider {
    private static final String WARNING_ORE_DICT_MISSING = API.MOD_ID + ".manual.warning.missing.oreDict";

    @Override
    public ImageRenderer getImage(final String data) {
        final ItemStack[] stacks = OreDictionary.getOres(data).stream()
                .flatMap(stack -> getSubtypes(stack).stream())
                .toArray(ItemStack[]::new);
        if (stacks != null && stacks.length > 0) {
            return new ItemStackImageRenderer(stacks);
        } else {
            return new MissingItemRenderer(WARNING_ORE_DICT_MISSING);
        }
    }

    /**
     * Stolen from JEI.
     *
     * @author mezz
     */
    private static List<ItemStack> getSubtypes(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return Collections.emptyList();
        }

        if (itemStack.func_190926_b()) {
            return Collections.emptyList();
        }

        if (itemStack.func_77952_i() != OreDictionary.WILDCARD_VALUE) {
            return Collections.singletonList(itemStack);
        }

        return getSubtypes(itemStack.func_77973_b(), itemStack.func_190916_E());
    }

    /**
     * Stolen from JEI.
     *
     * @author mezz
     */
    private static List<ItemStack> getSubtypes(final Item item, final int stackSize) {
        List<ItemStack> itemStacks = new ArrayList<>();

        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            NonNullList<ItemStack> subItems = NonNullList.func_191196_a();
            try {
                item.func_150895_a(itemTab, subItems);
            } catch (RuntimeException | LinkageError e) {
                BWMod.getLog().warn("Caught a crash while getting sub-items of {}", item, e);
            }

            for (ItemStack subItem : subItems) {
                if (subItem == null) {
                    BWMod.getLog().warn("Found a null subItem of {}", item);
                } else if (subItem.func_190926_b()) {
                    BWMod.getLog().warn("Found an empty subItem of {}", item);
                } else {
                    if (subItem.func_190916_E() != stackSize) {
                        ItemStack subItemCopy = subItem.func_77946_l();
                        subItemCopy.func_190920_e(stackSize);
                        itemStacks.add(subItemCopy);
                    } else {
                        itemStacks.add(subItem);
                    }
                }
            }
        }

        return itemStacks;
    }
}
