package betterwithmods.manual.client.gui;

import betterwithmods.manual.client.manual.Document;
import betterwithmods.manual.client.manual.segment.InteractiveSegment;
import betterwithmods.manual.client.manual.segment.Segment;
import betterwithmods.manual.client.renderer.TextureLoader;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.manual.common.api.ManualDefinitionImpl.Tab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;

@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
@SideOnly(Side.CLIENT)
public final class GuiManual extends GuiScreen {
    private static final int documentMaxWidth = 220;
    private static final int documentMaxHeight = 192;
    private static final int scrollPosX = 250;
    private static final int scrollPosY = 48;
    private static final int scrollWidth = 26;
    private static final int scrollHeight = 180;
    private static final int tabPosX = -52;
    private static final int tabPosY = 40;
    private static final int tabWidth = 64;
    private static final int tabHeight = 32;
    private static final int tabOverlap = 8;
    private static final int maxTabsPerSide = 7;
    private static final int windowWidth = 256;
    private static final int windowHeight = 256;

    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;

    private boolean isDragging = false;
    private Segment document = null;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();

    private ImageButton scrollButton = null;

    private final ManualDefinitionImpl myManual;

    public GuiManual() {
        myManual = ManualDefinitionImpl.INSTANCE;
    }

    public GuiManual(ManualDefinitionImpl manual) {
        myManual = manual;
    }

    public void pushPage(final String path) {
        if (!myManual.peekPath().equals(path)) {
            myManual.pushPath(path);
            refreshPage();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        final ScaledResolution screenSize = new ScaledResolution(field_146297_k.field_71443_c, field_146297_k.field_71440_d);
        final ScaledResolution guiSize = new ScaledResolution(windowWidth, windowHeight);
        final int midX = screenSize.scaledWidth / 2;
        final int midY = screenSize.scaledHeight / 2;
        guiLeft = midX - guiSize.scaledWidth / 2;
        guiTop = midY - guiSize.scaledHeight / 2;
        xSize = guiSize.scaledWidth;
        ySize = guiSize.scaledHeight;

        for (int i = 0; i < myManual.getTabs().size() && i < maxTabsPerSide; i++) {
            final int x = guiLeft + tabPosX;
            final int y = guiTop + tabPosY + i * (tabHeight - tabOverlap);
            field_146292_n.add(new ImageButton(i, x, y, tabWidth, tabHeight - tabOverlap - 1, TextureLoader.LOCATION_MANUAL_TAB).setImageHeight(tabHeight).setVerticalImageOffset(-tabOverlap / 2));
        }

        scrollButton = new ImageButton(-1, guiLeft + scrollPosX, guiTop + scrollPosY, 26, 13, TextureLoader.LOCATION_MANUAL_SCROLL);
        field_146292_n.add(scrollButton);

        refreshPage();
    }

    @Override
    public void func_73863_a(final int mouseX, final int mouseY, final float partialTicks) {
        GlStateManager.func_179147_l();

        super.func_73863_a(mouseX, mouseY, partialTicks);

        field_146297_k.field_71446_o.func_110577_a(TextureLoader.LOCATION_MANUAL_BACKGROUND);
        Gui.func_146110_a(guiLeft, guiTop, 0, 0, xSize, ySize, windowWidth, windowHeight);

        scrollButton.field_146124_l = canScroll();
        scrollButton.hoverOverride = isDragging;

        for (int i = 0; i < myManual.getTabs().size() && i < maxTabsPerSide; i++) {
            final Tab tab = myManual.getTabs().get(i);
            final ImageButton button = (ImageButton) field_146292_n.get(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b(button.field_146128_h + 30, button.field_146129_i + 4 - tabOverlap / 2, field_73735_i);
            tab.renderer.render();
            GlStateManager.func_179121_F();
        }

        currentSegment = Document.render(document, guiLeft + 16, guiTop + 32, documentMaxWidth, documentMaxHeight, offset(), getFontRenderer(), mouseX, mouseY);

        if (!isDragging) {
            currentSegment.ifPresent(s -> s.tooltip().ifPresent(t -> drawHoveringText(Collections.singletonList(I18n.func_135052_a(t)), mouseX, mouseY, getFontRenderer())));

            for (int i = 0; i < myManual.getTabs().size() && i < maxTabsPerSide; i++) {
                final Tab tab = myManual.getTabs().get(i);
                final ImageButton button = (ImageButton) field_146292_n.get(i);
                if (mouseX > button.field_146128_h && mouseX < button.field_146128_h + button.field_146120_f && mouseY > button.field_146129_i && mouseY < button.field_146129_i + button.field_146121_g) {
                    if (tab.tooltip != null) {
                        drawHoveringText(Collections.singletonList(I18n.func_135052_a(tab.tooltip)), mouseX, mouseY, getFontRenderer());
                    }
                }
            }
        }

        if (canScroll() && (isCoordinateOverScrollBar(mouseX - guiLeft, mouseY - guiTop) || isDragging)) {
            drawHoveringText(Collections.singletonList(100 * offset() / maxOffset() + "%"), guiLeft + scrollPosX + scrollWidth, scrollButton.field_146129_i + scrollButton.field_146121_g + 1, getFontRenderer());
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();

        if (Mouse.hasWheel() && Mouse.getEventDWheel() != 0) {
            if (Math.signum(Mouse.getEventDWheel()) < 0) {
                scrollDown();
            } else {
                scrollUp();
            }
        }
    }

    @Override
    protected void func_73869_a(final char ch, final int code) throws IOException {
        if (code == field_146297_k.field_71474_y.field_74314_A.func_151463_i()) {
            popPage();
        } else if (code == field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(ch, code);
        }
    }

    @Override
    protected void func_73864_a(final int mouseX, final int mouseY, final int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);

        if (canScroll() && button == 0 && isCoordinateOverScrollBar(mouseX - guiLeft, mouseY - guiTop)) {
            isDragging = true;
            scrollMouse(mouseY);
        } else if (button == 0) {
            currentSegment.ifPresent(s -> s.onMouseClick(mouseX, mouseY));
        } else if (button == 1) {
            popPage();
        }
    }

    @Override
    protected void func_146273_a(final int mouseX, final int mouseY, final int lastButtonClicked, final long timeSinceMouseClick) {
        super.func_146273_a(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
        if (isDragging) {
            scrollMouse(mouseY);
        }
    }

    @Override
    protected void func_146286_b(final int mouseX, final int mouseY, final int button) {
        super.func_146286_b(mouseX, mouseY, button);
        if (button == 0) {
            isDragging = false;
        }
    }

    @Override
    protected void func_146284_a(final GuiButton button) throws IOException {
        if (button.field_146127_k >= 0 && button.field_146127_k < myManual.getTabs().size()) {
            myManual.navigate(myManual.getTabs().get(button.field_146127_k).path);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    // --------------------------------------------------------------------- //

    private FontRenderer getFontRenderer() {
        return field_146289_q;
    }

    private boolean canScroll() {
        return maxOffset() > 0;
    }

    private int offset() {
        return myManual.peekOffset();
    }

    private int maxOffset() {
        return documentHeight - documentMaxHeight;
    }

    private void refreshPage() {
        final String language = FMLCommonHandler.instance().getCurrentLanguage();
        final Iterable<String> content = myManual.contentFor(myManual.peekPath());
        document = Document.parse(myManual, content != null ? content : Collections.singletonList("Document not found: " + ManualDefinitionImpl.PATTERN_LANGUAGE_KEY.matcher(myManual.peekPath()).replaceAll(language)));
        documentHeight = Document.height(document, documentMaxWidth, getFontRenderer());
        scrollTo(offset());
    }

    private void popPage() {
        if (myManual.getHistorySize() > 1) {
            myManual.popPath();
            refreshPage();
        } else {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    private void scrollMouse(final int mouseY) {
        scrollTo((int) Math.round((mouseY - guiTop - scrollPosY - 6.5) * maxOffset() / (scrollHeight - 13.0)));
    }

    private void scrollUp() {
        scrollTo(offset() - Document.lineHeight(getFontRenderer()) * 3);
    }

    private void scrollDown() {
        scrollTo(offset() + Document.lineHeight(getFontRenderer()) * 3);
    }

    private void scrollTo(final int row) {
        myManual.setOffset(Math.max(0, Math.min(maxOffset(), row)));
        final int yMin = guiTop + scrollPosY;
        if (maxOffset() > 0) {
            scrollButton.field_146129_i = yMin + (scrollHeight - 13) * offset() / maxOffset();
        } else {
            scrollButton.field_146129_i = yMin;
        }
    }

    private boolean isCoordinateOverScrollBar(final int x, final int y) {
        return x > scrollPosX && x < scrollPosX + scrollWidth &&
                y >= scrollPosY && y < scrollPosY + scrollHeight;
    }

    private static class ImageButton extends GuiButton {
        private final ResourceLocation image;
        private boolean hoverOverride = false;
        private int verticalImageOffset = 0;
        private int imageHeightOverride = 0;

        public ImageButton(final int id, final int x, final int y, final int w, final int h, final ResourceLocation image) {
            super(id, x, y, w, h, "");
            this.image = image;
        }

        public ImageButton setImageHeight(final int height) {
            this.imageHeightOverride = height;
            return this;
        }

        public ImageButton setVerticalImageOffset(final int offset) {
            this.verticalImageOffset = offset;
            return this;
        }

        @Override
        public void func_191745_a(final Minecraft mc, final int mouseX, final int mouseY, float partialTicks) {
            if (field_146125_m) {
                mc.func_110434_K().func_110577_a(image);
                GlStateManager.func_179131_c(1, 1, 1, 1);

                field_146123_n = mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + field_146120_f && mouseY < field_146129_i + field_146121_g;

                final int x0 = field_146128_h;
                final int x1 = field_146128_h + field_146120_f;
                final int y0 = field_146129_i + verticalImageOffset;
                final int y1 = field_146129_i + verticalImageOffset + ((imageHeightOverride > 0) ? imageHeightOverride : field_146121_g);

                final double u0 = 0;
                final double u1 = u0 + 1;
                final double v0 = (hoverOverride || func_146114_a(field_146123_n) == 2) ? 0.5 : 0;
                final double v1 = v0 + 0.5;

                final Tessellator t = Tessellator.func_178181_a();
                final BufferBuilder b = t.func_178180_c();
                b.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);
                b.func_181662_b(x0, y1, field_73735_i).func_187315_a(u0, v1).func_181675_d();
                b.func_181662_b(x1, y1, field_73735_i).func_187315_a(u1, v1).func_181675_d();
                b.func_181662_b(x1, y0, field_73735_i).func_187315_a(u1, v0).func_181675_d();
                b.func_181662_b(x0, y0, field_73735_i).func_187315_a(u0, v0).func_181675_d();
                t.func_78381_a();
            }
        }
    }

    private static class ScaledResolution {
        public final int scaledWidth;
        public final int scaledHeight;

        public ScaledResolution(final int width, final int height) {
            int scaleFactor = 1;
            int guiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;

            if (guiScale == 0) {
                guiScale = 1000;
            }

            while (scaleFactor < guiScale && width / (scaleFactor + 1) >= 320 && height / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }

            if (Minecraft.func_71410_x().func_152349_b() && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }

            this.scaledWidth = MathHelper.func_76143_f(width / (double) scaleFactor);
            this.scaledHeight = MathHelper.func_76143_f(height / (double) scaleFactor);
        }
    }
}
