package betterwithmods.event;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PenaltyEventHandler {

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer) event.getEntityLiving();

            //Whether the player can jump.
            if (!BWRegistry.PENALTY_HANDLERS.canJump(player)) {
                event.getEntityLiving().field_70159_w = 0;
                event.getEntityLiving().field_70181_x = 0;
                event.getEntityLiving().field_70179_y = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!PlayerHelper.isSurvival(player))
            return;

        //Handle whether the player can sprint
        if (!BWRegistry.PENALTY_HANDLERS.canSprint(player)) {
            player.func_70031_b(false);
        }

        //Swimming
        if (player.func_70090_H() && !BWRegistry.PENALTY_HANDLERS.canSwim(player)) {
            if (!PlayerHelper.isNearBottom(player)) {
                    player.field_70181_x -= 0.04;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer) event.getEntityLiving();
            if (!PlayerHelper.isSurvival(player))
                return;
            //Speed
            double speed = BWRegistry.PENALTY_HANDLERS.getSpeedModifier(player);
            if (speed != 0) {
                PlayerHelper.changeSpeed(player, "Penalty Speed Modifier", speed, PlayerHelper.PENALTY_SPEED_UUID);
            }
            //Pain
            if (BWRegistry.PENALTY_HANDLERS.inPain(player)) {
                if (PlayerHelper.isMoving(player) && player.field_70170_p.func_72820_D() % 60 == 0) {
                    player.func_184185_a(BWSounds.OOF, 0.75f, 1f);
                }
            }

        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer) event.getSource().func_76346_g();
            if (PlayerHelper.isSurvival(player)) {
                if (!BWRegistry.PENALTY_HANDLERS.canAttack(player)) {
                    player.func_184185_a(BWSounds.OOF, 0.75f, 1f);
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}
